/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.expressions;

import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class LowerCaseForCaseInsensitiveTest
extends TestCase {
    protected String operation;
    public static final String LikeIgnoreCase = "LikeIgnoreCase";
    public static final String EqualsIgnoreCase = "EqualsIgnoreCase";
    public static final String ContainsSubstringIgnoringCase = "ContainsSubstringIgnoringCase";
    protected boolean previousUppercaseDefaultValue = Expression.shouldUseUpperCaseForIgnoreCase;
    protected Employee employee;
    protected String sharpS = "\u00df";
    protected String uUmlaut = "\u00fc";

    public LowerCaseForCaseInsensitiveTest(String operation) {
        this.operation = operation;
        this.setName(this.getName() + " : " + operation);
        this.setDescription("Test default lowercase for case-insensitive expressions");
    }

    public void setup() {
        Expression.shouldUseUpperCaseForIgnoreCase = false;
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.employee = new Employee();
        Employee employeeClone = (Employee)uow.registerObject((Object)this.employee);
        employeeClone.setFirstName("Heinz");
        employeeClone.setLastName("S\u00fc\u00dfig");
        employeeClone.setMale();
        uow.commit();
    }

    public void test() {
        if (this.operation == null) {
            LowerCaseForCaseInsensitiveTest.fail((String)"Test invoked with a null operation");
        } else if (this.operation.equals(LikeIgnoreCase)) {
            this.testLikeIgnoreCase(false);
            this.testLikeIgnoreCase(true);
        } else if (this.operation.equals(EqualsIgnoreCase)) {
            this.testEqualsIgnoreCase(false);
            this.testEqualsIgnoreCase(true);
        } else if (this.operation.equals(ContainsSubstringIgnoringCase)) {
            this.testContainsSubstringIgnoringCase(false);
            this.testContainsSubstringIgnoringCase(true);
        } else {
            LowerCaseForCaseInsensitiveTest.fail((String)("Test invoked with invalid operation: " + this.operation));
        }
    }

    public void testEqualsIgnoreCase(boolean checkCacheOnly) {
        String value = "s" + this.uUmlaut + this.sharpS + "IG";
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        if (checkCacheOnly) {
            query.checkCacheOnly();
        }
        query.setSelectionCriteria(new ExpressionBuilder().get("lastName").equalsIgnoreCase(value));
        Vector results = (Vector)this.getSession().executeQuery((DatabaseQuery)query);
        LowerCaseForCaseInsensitiveTest.assertEquals((String)("One result expected (checkCacheOnly=" + checkCacheOnly + ")"), (int)1, (int)results.size());
        LowerCaseForCaseInsensitiveTest.assertTrue((String)("Persisted employee expected in results (checkCacheOnly=" + checkCacheOnly + ")"), (boolean)results.contains(this.employee));
    }

    public void testLikeIgnoreCase(boolean checkCacheOnly) {
        String value = "S" + this.uUmlaut + this.sharpS + "ig";
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        if (checkCacheOnly) {
            query.checkCacheOnly();
        }
        query.setSelectionCriteria(new ExpressionBuilder().get("lastName").likeIgnoreCase(value));
        Vector results = (Vector)this.getSession().executeQuery((DatabaseQuery)query);
        LowerCaseForCaseInsensitiveTest.assertEquals((String)("One result expected (checkCacheOnly=" + checkCacheOnly + ")"), (int)1, (int)results.size());
        LowerCaseForCaseInsensitiveTest.assertTrue((String)("Persisted employee expected in results (checkCacheOnly=" + checkCacheOnly + ")"), (boolean)results.contains(this.employee));
    }

    public void testContainsSubstringIgnoringCase(boolean checkCacheOnly) {
        String value = this.uUmlaut + this.sharpS;
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        if (checkCacheOnly) {
            query.checkCacheOnly();
        }
        query.setSelectionCriteria(new ExpressionBuilder().get("lastName").containsSubstringIgnoringCase(value));
        Vector results = (Vector)this.getSession().executeQuery((DatabaseQuery)query);
        LowerCaseForCaseInsensitiveTest.assertEquals((String)("One result expected (checkCacheOnly=" + checkCacheOnly + ")"), (int)1, (int)results.size());
        LowerCaseForCaseInsensitiveTest.assertTrue((String)("Persisted employee expected in results (checkCacheOnly=" + checkCacheOnly + ")"), (boolean)results.contains(this.employee));
    }

    public void reset() {
        Expression.shouldUseUpperCaseForIgnoreCase = this.previousUppercaseDefaultValue;
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.deleteObject(uow.registerObject((Object)this.employee));
        uow.commit();
    }
}

