/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.interfaces;

import junit.framework.Test;
import org.eclipse.persistence.testing.framework.DeleteObjectTest;
import org.eclipse.persistence.testing.framework.InsertObjectTest;
import org.eclipse.persistence.testing.framework.ReadAllTest;
import org.eclipse.persistence.testing.framework.ReadObjectTest;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.framework.UnitOfWorkBasicUpdateObjectTest;
import org.eclipse.persistence.testing.framework.WriteObjectTest;
import org.eclipse.persistence.testing.models.interfaces.Commercial;
import org.eclipse.persistence.testing.models.interfaces.InterfaceWithTablesSystem;
import org.eclipse.persistence.testing.models.interfaces.Network;
import org.eclipse.persistence.testing.models.interfaces.Program;
import org.eclipse.persistence.testing.models.interfaces.Show;
import org.eclipse.persistence.testing.models.interfaces.TVSchedule;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;

public class InterfaceWithTablesTestModel
extends TestModel {
    public InterfaceWithTablesTestModel() {
        this.setDescription("This model tests interface support, where the interfaces have tables in the database");
    }

    public void addRequiredSystems() {
        this.addRequiredSystem(new InterfaceWithTablesSystem());
    }

    public void addTests() {
        this.addTest((Test)InterfaceWithTablesTestModel.getReadObjectTestSuite());
        this.addTest((Test)InterfaceWithTablesTestModel.getReadAllTestSuite());
        this.addTest((Test)InterfaceWithTablesTestModel.getDeleteObjectTestSuite());
        this.addTest((Test)InterfaceWithTablesTestModel.getInsertObjectTestSuite());
        this.addTest((Test)InterfaceWithTablesTestModel.getUpdateObjectTestSuite());
    }

    public static TestSuite getDeleteObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("InterfaceWithTablesDeleteObjectTestSuite");
        suite.setDescription("This suite tests the deletion of each object in the interface model (with tables).");
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(TVSchedule.class, "example1")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(Show.class, "example2")));
        return suite;
    }

    public static TestSuite getInsertObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("InserfaceWithTablesInsertObjectTestSuite");
        suite.setDescription("This suite tests the insertion of each object in the interface model (with tables).");
        Show show = new Show();
        show.setName("Flintstones");
        suite.addTest((Test)new InsertObjectTest((Object)show));
        return suite;
    }

    public static TestSuite getReadAllTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("InterfaceWithTablesReadAllTestSuite");
        suite.setDescription("This suite tests the reading of all the objects of each class in the interface model (with tables).");
        suite.addTest((Test)new ReadAllTest(Program.class, 2));
        suite.addTest((Test)new ReadAllTest(TVSchedule.class, 1));
        return suite;
    }

    public static TestSuite getReadObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("InterfaceWithTablesReadObjectTestSuite");
        suite.setDescription("This suite test the reading of each object in the interface model (with tables).");
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new ReadObjectTest(manager.getObject(TVSchedule.class, "example1")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(Show.class, "example2")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(Network.class, "example1")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(Commercial.class, "example1")));
        return suite;
    }

    public static TestSuite getUpdateObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("InterfaceWithTablesUpdateObjectTestSuite");
        suite.setDescription("This suite tests the updating of each object in the interface model (with tables).");
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new WriteObjectTest(manager.getObject(TVSchedule.class, "example1")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(TVSchedule.class, "example1")));
        return suite;
    }
}

