/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.optimisticlocking;

import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.optimisticlocking.LockObject;

public class OptimisticLockingUpdateTest
extends AutoVerifyTestCase {
    protected UnitOfWork uow;
    protected Object originalObject;
    protected Class domainClass;
    protected boolean useUOW;

    public OptimisticLockingUpdateTest(Class aClass, boolean useUnitOfWork) {
        this.setName(this.getName() + "(" + aClass + ")");
        this.domainClass = aClass;
        this.useUOW = useUnitOfWork;
        this.setDescription("This test verifies that an object gets updated properly, and that the lock value gets updated in memory");
    }

    protected void setup() {
        this.beginTransaction();
        if (this.useUOW) {
            this.uow = this.getSession().acquireUnitOfWork();
            this.originalObject = this.uow.readObject(this.domainClass);
        } else {
            this.originalObject = this.getSession().readObject(this.domainClass);
        }
    }

    public void reset() {
        this.rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    public void test() {
        ((LockObject)this.originalObject).value = "June is hot";
        if (this.useUOW) {
            this.uow.commit();
        } else {
            this.getDatabaseSession().updateObject(this.originalObject);
        }
    }

    protected void verify() {
        boolean exceptionCaught = false;
        try {
            this.getDatabaseSession().deleteObject(this.originalObject);
        }
        catch (OptimisticLockException exception) {
            exceptionCaught = true;
        }
        if (exceptionCaught) {
            throw new TestErrorException("Lock value not updated in Identity Map");
        }
    }
}

