/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.workbenchintegration.QueryOptions;

import java.util.Vector;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class MemoryQueryReturnConfirmedTest
extends AutoVerifyTestCase {
    protected Employee employee;
    protected ReadAllQuery queryAll;
    protected ReadObjectQuery queryObject;
    protected Vector allEmployees;
    protected Vector inMemoryResult;

    public MemoryQueryReturnConfirmedTest() {
        this.setDescription("Test memory query ignore indirection exception return conformed option");
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.queryAll = (ReadAllQuery)this.getSession().getDescriptor(Employee.class).getQueryManager().getQuery("memoryQueryReturnConfirmedQuery");
        this.allEmployees = (Vector)this.getSession().executeQuery((DatabaseQuery)this.queryAll);
        this.queryObject = new ReadObjectQuery(Employee.class);
        this.queryObject.setSelectionCriteria(new ExpressionBuilder().get("address").get("city").notEqual((Object)"Montreal"));
        this.employee = (Employee)this.getSession().executeQuery((DatabaseQuery)this.queryObject);
        if (this.employee != null) {
            this.employee.getAddress();
        }
        this.queryObject.setSelectionCriteria(new ExpressionBuilder().get("address").get("city").equal((Object)"Montreal"));
        this.employee = (Employee)this.getSession().executeQuery((DatabaseQuery)this.queryObject);
        if (this.employee != null) {
            this.employee.getAddress();
        }
    }

    public void test() {
        ReadAllQuery queryAllCopy = (ReadAllQuery)this.queryAll.clone();
        queryAllCopy.checkCacheOnly();
        queryAllCopy.setSelectionCriteria(new ExpressionBuilder().get("address").get("city").equal((Object)"Montreal"));
        this.inMemoryResult = (Vector)this.getSession().executeQuery((DatabaseQuery)queryAllCopy);
    }

    public void verify() {
        if (this.inMemoryResult.size() != this.allEmployees.size() - 1) {
            throw new TestErrorException("In Memory Query did not return all objects because of indirection.  TopLink is not returning indirection relationships as conformed when the policy is set to do so.");
        }
    }
}

