/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.feature;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.DescriptorEventAdapter;
import org.eclipse.persistence.descriptors.DescriptorEventListener;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.sequencing.NativeSequence;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sessions.Record;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.sequencing.SeqTestClass1;

public class SequenceFieldRemovalForAcquireValueAfterInsertTest
extends TestCase {
    protected ClassDescriptor descriptor;
    protected SQLStringListener sqlListener;
    protected ModifyRowModifier modifyRowModifier;
    protected Sequence oldSequence;
    protected String sqlString;

    public SequenceFieldRemovalForAcquireValueAfterInsertTest() {
        this.setDescription("Tests removing the sequence field from an SQL insert statement, when Sequencing shouldAcquireValueAfterInsert is true");
    }

    public void setup() {
        this.descriptor = this.getSession().getDescriptor(SeqTestClass1.class);
        String sequenceNumberName = this.descriptor.getSequenceNumberName();
        Sequence sequence = this.getSession().getLogin().getSequence(sequenceNumberName);
        DatabasePlatform platform = this.getDatabaseSession().getPlatform();
        if (!platform.supportsNativeSequenceNumbers() || !platform.supportsIdentity()) {
            throw new TestWarningException("Test only supported on platforms supporting sequencing and identity");
        }
        if (!sequence.isNative()) {
            this.oldSequence = sequence;
            NativeSequence newSequence = new NativeSequence(sequenceNumberName, 1);
            newSequence.setShouldAcquireValueAfterInsert(true);
            this.getDatabaseSession().getLogin().removeSequence(sequenceNumberName);
            this.getDatabaseSession().getLogin().addSequence((Sequence)newSequence);
            this.getDatabaseSession().getSequencingControl().resetSequencing();
        }
        this.sqlListener = new SQLStringListener();
        this.descriptor.getEventManager().addListener((DescriptorEventListener)this.sqlListener);
        this.modifyRowModifier = new ModifyRowModifier();
        this.descriptor.getEventManager().addListener((DescriptorEventListener)this.modifyRowModifier);
        this.beginTransaction();
    }

    public void test() {
        UnitOfWork uow = this.getDatabaseSession().acquireUnitOfWork();
        SeqTestClass1 object = new SeqTestClass1();
        object.setTest1("aTestValue");
        object.setTest2("omit_this_field");
        uow.registerObject((Object)object);
        try {
            uow.commit();
            this.sqlString = this.sqlListener.getSQLString();
        }
        catch (DatabaseException d) {
            this.sqlString = ((DatabaseCall)d.getCall()).getSQLString();
        }
        if (this.sqlString == null) {
            throw new TestErrorException("Generated SQL string is null");
        }
    }

    public void reset() {
        this.rollbackTransaction();
        if (this.sqlListener != null) {
            this.descriptor.getEventManager().removeListener((DescriptorEventListener)this.sqlListener);
        }
        if (this.modifyRowModifier != null) {
            this.descriptor.getEventManager().removeListener((DescriptorEventListener)this.modifyRowModifier);
        }
        if (this.oldSequence != null) {
            this.getDatabaseSession().getLogin().removeSequence(this.descriptor.getSequenceNumberName());
            this.getDatabaseSession().getLogin().addSequence(this.oldSequence);
            this.oldSequence = null;
            this.getDatabaseSession().getSequencingControl().resetSequencing();
        }
    }

    public void verify() {
        String fieldName = this.descriptor.getSequenceNumberField().getName();
        String qualifiedFieldName = this.descriptor.getSequenceNumberField().getQualifiedName();
        if (this.sqlString.indexOf(qualifiedFieldName) != -1 || this.sqlString.indexOf(fieldName) != -1) {
            throw new TestErrorException("Invalid SQL String - sequence field " + fieldName + " was included in SQL: (" + this.sqlString + ")- incorrect for shouldAcquireValueAfterInsert = true");
        }
    }

    class ModifyRowModifier
    extends DescriptorEventAdapter {
        public static final String OMISSION_MARKER = "omit_this_field";

        ModifyRowModifier() {
        }

        public void aboutToInsert(DescriptorEvent event) {
            Record modifyRow = event.getRecord();
            Object[] keys = modifyRow.keySet().toArray();
            for (int i = 0; i < keys.length; ++i) {
                Object key = keys[i];
                Object value = modifyRow.get(key);
                if (value == null || !value.equals(OMISSION_MARKER)) continue;
                modifyRow.remove(key);
            }
        }
    }

    class SQLStringListener
    extends DescriptorEventAdapter {
        protected String sqlString;

        SQLStringListener() {
        }

        public void postInsert(DescriptorEvent event) {
            this.sqlString = event.getQuery().getSQLString();
        }

        public String getSQLString() {
            return this.sqlString;
        }
    }
}

