/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.tests.validation.Employee;
import org.eclipse.persistence.testing.tests.validation.ExceptionTest;

public class SequenceFieldNameNotSetTest
extends ExceptionTest {
    public SequenceFieldNameNotSetTest() {
        this.setDescription("This test attempts to register a descriptor that uses sequencing but doesn't set the sequence field name.");
    }

    public RelationalDescriptor descriptor() {
        RelationalDescriptor employeeDescriptor = new RelationalDescriptor();
        employeeDescriptor.setJavaClass(Employee.class);
        employeeDescriptor.setTableName("VAL_EMP");
        employeeDescriptor.setPrimaryKeyFieldName("ID");
        employeeDescriptor.setSequenceNumberName("SEQ");
        return employeeDescriptor;
    }

    protected void setup() {
        this.expectedException = DescriptorException.sequenceNumberPropertyNotSpecified(null);
    }

    public void test() {
        try {
            this.getSession().setIntegrityChecker(new IntegrityChecker());
            this.getSession().getIntegrityChecker().dontCatchExceptions();
            ((DatabaseSession)this.getSession()).addDescriptor((ClassDescriptor)this.descriptor());
        }
        catch (EclipseLinkException exception) {
            this.caughtException = exception;
        }
    }
}

