/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.buildtools.ant.taskdefs;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.LogLevel;
import org.apache.tools.ant.util.FileUtils;

public class Say
extends Task {
    private String encoding = "";
    private String ifProperty;
    private String unlessProperty;
    protected boolean append = false;
    protected int level = 1;
    protected File outfile = null;
    protected String message = "";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        if (!this.testIf()) return;
        if (!this.testUnless()) return;
        if (this.outfile == null) {
            this.log(this.message, this.level);
            return;
        }
        Writer outbuffer = null;
        try {
            String f = this.outfile.getAbsolutePath();
            outbuffer = this.encoding.length() == 0 || this.encoding == null ? new FileWriter(f, this.append) : new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f, this.append), this.encoding));
            ((Writer)outbuffer).write(this.message, 0, this.message.length());
        }
        catch (IOException e) {
            try {
                throw new BuildException((Throwable)e, this.getLocation());
            }
            catch (Throwable throwable) {
                FileUtils.close(outbuffer);
                throw throwable;
            }
        }
        FileUtils.close((Writer)outbuffer);
    }

    private boolean testIf() {
        if (this.ifProperty == null || this.ifProperty.equals("")) {
            return true;
        }
        return this.getProject().getProperty(this.ifProperty) != null;
    }

    private boolean testUnless() {
        if (this.unlessProperty == null || this.unlessProperty.equals("")) {
            return true;
        }
        return this.getProject().getProperty(this.unlessProperty) == null;
    }

    public void addText(String singlelinemsg) {
        this.message = this.message + this.getProject().replaceProperties(singlelinemsg);
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setFile(File outfile) {
        this.outfile = outfile;
    }

    public void setIf(String c) {
        this.ifProperty = c;
    }

    public void setLevel(SayLevel sayLevel) {
        this.level = sayLevel.getLevel();
    }

    public void setMessage(String singlelinemsg) {
        this.message = singlelinemsg;
    }

    public void setUnless(String c) {
        this.unlessProperty = c;
    }

    public static class SayLevel
    extends LogLevel {
    }
}

