/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.advanced.PhoneNumber;
import org.eclipse.persistence.testing.models.jpa.advanced.Project;
import org.eclipse.persistence.testing.tests.jpa.CMP3TestModel;
import org.eclipse.persistence.testing.tests.jpa.EntityContainerTestBase;

public class EMCascadingPersistAndFlushTest
extends EntityContainerTestBase {
    public Integer[] empIDs = new Integer[2];
    public Integer[] projIDs = new Integer[3];
    public ArrayList phones = new ArrayList(2);
    public HashMap persistedItems = new HashMap(4);
    Employee employee = null;
    Project project = null;
    PhoneNumber phone = null;

    public EMCascadingPersistAndFlushTest() {
        this.setDescription("Test cascading persist and flush in EntityManager");
    }

    @Override
    public void setup() {
        super.setup();
        if (CMP3TestModel.getServerSession().getDescriptor(Employee.class).getSequence().shouldAcquireValueAfterInsert() || CMP3TestModel.getServerSession().getDescriptor(Project.class).getSequence().shouldAcquireValueAfterInsert()) {
            throw new TestWarningException("Can't run this test with Sybase-type native sequencing for Employee or/and Project");
        }
    }

    @Override
    public void reset() {
        if (this.phones != null) {
            this.phones.clear();
        }
        super.reset();
    }

    public void test() {
        this.employee = new Employee();
        this.employee.setFirstName("First");
        this.employee.setLastName("Bean");
        this.project = new Project();
        this.project.setName("Project # 1");
        this.project.setDescription("A simple Project");
        this.phone = new PhoneNumber("Work", "613", "9876543");
        this.employee.addProject(this.project);
        this.employee.addPhoneNumber(this.phone);
        try {
            this.beginTransaction();
            this.getEntityManager().persist((Object)this.employee);
            this.empIDs[0] = this.employee.getId();
            this.persistedItems.put("after persist Employee", this.getEntityManager().find(Employee.class, (Object)this.empIDs[0]));
            Project project1 = (Project)this.employee.getProjects().iterator().next();
            this.persistedItems.put("after persist Project", project1);
            this.projIDs[0] = this.project.getId();
            PhoneNumber phone1 = (PhoneNumber)this.employee.getPhoneNumbers().iterator().next();
            this.persistedItems.put("after persist PhoneNumber", phone1);
            this.phones.add(this.phone.buildPK());
            this.getEntityManager().flush();
            ((JpaEntityManager)this.getEntityManager()).getActiveSession().getIdentityMapAccessor().initializeAllIdentityMaps();
            this.persistedItems.put("after flush Employee", this.getEntityManager().find(Employee.class, (Object)this.empIDs[0]));
            this.persistedItems.put("after flush Project", this.getEntityManager().find(Project.class, (Object)this.projIDs[0]));
            this.persistedItems.put("after flush PhoneNumber", this.getEntityManager().find(PhoneNumber.class, this.phones.get(0)));
            this.commitTransaction();
        }
        catch (Exception ex) {
            this.rollbackTransaction();
            throw new TestErrorException("Exception thrown durring persist and flush" + ex);
        }
    }

    public void verify() {
        if (this.persistedItems.get("after persist Employee") == null) {
            throw new TestErrorException("Find after persist Employee: " + this.empIDs[0] + " is not found in the cache");
        }
        if (this.persistedItems.get("after persist Project") == null) {
            throw new TestErrorException("Find after persist Project: requried Project is not found in the cache");
        }
        if (!((Project)this.persistedItems.get("after persist Project")).getId().equals(this.projIDs[0])) {
            throw new TestErrorException("Find after persist Project: " + this.projIDs[0] + " is not found in the cache");
        }
        if (this.persistedItems.get("after persist PhoneNumber") == null) {
            throw new TestErrorException("Find after persist PhoneNumber: required PhoneNumber is not found in the cache");
        }
        if (!((PhoneNumber)this.persistedItems.get("after persist PhoneNumber")).buildPK().equals(this.phones.get(0))) {
            throw new TestErrorException("Find after persist PhoneNumber: " + this.phones.get(0) + " is not found in the cache");
        }
        if (this.persistedItems.get("after flush Employee") == null) {
            throw new TestErrorException("Find after flush Employee: " + this.empIDs[0] + " is not persisted");
        }
        if (this.persistedItems.get("after flush Project") == null) {
            throw new TestErrorException("Find after flush Project: requried Project is not persisted");
        }
        if (!((Project)this.persistedItems.get("after flush Project")).getId().equals(this.projIDs[0])) {
            throw new TestErrorException("Find after flush Project: " + this.projIDs[0] + " is not persisted");
        }
        if (this.persistedItems.get("after flush PhoneNumber") == null) {
            throw new TestErrorException("Find after flush PhoneNumber: required PhoneNumber is not persisted");
        }
        if (!((PhoneNumber)this.persistedItems.get("after flush PhoneNumber")).buildPK().equals(this.phones.get(0))) {
            throw new TestErrorException("Find after flush PhoneNumber: " + this.phones.get(0) + " is not persisted");
        }
    }
}

