/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.aggregate;

import java.util.Collection;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.aggregate.GolfClub;
import org.eclipse.persistence.testing.models.aggregate.GolfClubShaft;

public class QueryKeyInAggregateTest
extends TestCase {
    protected boolean conforming;
    protected Exception exception;
    protected Collection results;
    protected GolfClub originalClub;
    protected GolfClub originalClub2;

    public QueryKeyInAggregateTest(boolean shouldConform) {
        this.conforming = shouldConform;
        this.setName(this.getName() + " conforming: " + shouldConform);
        this.setDescription("Test querying on a manual QueryKey defined in an aggregate object");
    }

    public void setup() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.originalClub = (GolfClub)uow.registerObject((Object)new GolfClub());
        GolfClubShaft shaft = new GolfClubShaft();
        shaft.setStiffnessRating("LX");
        this.originalClub.setShaft(shaft);
        this.originalClub2 = (GolfClub)uow.registerObject((Object)new GolfClub());
        GolfClubShaft shaft2 = new GolfClubShaft();
        shaft2.setStiffnessRating("LX");
        this.originalClub2.setShaft(shaft2);
        uow.commit();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        if (this.conforming) {
            GolfClub uncommittedClub = (GolfClub)uow.registerObject((Object)new GolfClub());
            GolfClubShaft shaft = new GolfClubShaft();
            shaft.setStiffnessRating("LX");
            uncommittedClub.setShaft(shaft);
        }
        ReadAllQuery query = new ReadAllQuery(GolfClub.class);
        ExpressionBuilder builder = query.getExpressionBuilder();
        Expression expression = builder.get("shaft").get("flexibility").equal((Object)"LX");
        query.setSelectionCriteria(expression);
        if (this.conforming) {
            query.conformResultsInUnitOfWork();
        }
        try {
            this.results = (Collection)uow.executeQuery((DatabaseQuery)query);
        }
        catch (Exception e) {
            this.exception = e;
        }
        finally {
            uow.release();
        }
    }

    public void verify() {
        if (this.exception != null) {
            this.throwError("An exception occurred whilst executing the query: " + this.exception);
        } else if (this.results == null || this.results.isEmpty()) {
            this.throwError("The query results were null or empty: " + this.results);
        }
        int expectedSize = this.conforming ? 3 : 2;
        if (this.results.size() != expectedSize) {
            this.throwError("Incorrect results size: " + this.results.size() + " " + this.results);
        }
    }

    public void reset() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.deleteObject((Object)this.originalClub);
        uow.deleteObject((Object)this.originalClub2);
        uow.commit();
        this.originalClub = null;
        this.originalClub2 = null;
        this.exception = null;
        this.results = null;
    }
}

