/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.feature;

import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.sequencing.SampleStringSequencingPolicy;
import org.eclipse.persistence.testing.models.sequencing.SeqTestClass2;

public class CustomSequencingPolicyTest
extends AutoVerifyTestCase {
    protected SeqTestClass2 obj1;
    protected SeqTestClass2 obj2;
    protected SeqTestClass2 obj3;
    protected SeqTestClass2 obj4;
    protected Sequence originalSequence;

    public CustomSequencingPolicyTest() {
        this.setDescription("Test custom sequencing policy, which produces sequences of type String");
    }

    protected void setup() {
        this.originalSequence = this.getSession().getLogin().getPlatform().getDefaultSequence();
        this.getSession().getPlatform().setDefaultSequence((Sequence)new SampleStringSequencingPolicy(this.originalSequence.getName(), "", this.originalSequence.getPreallocationSize()));
        ((DatabaseSession)this.getSession()).getSequencingControl().resetSequencing();
    }

    protected void test() {
        this.obj1 = new SeqTestClass2();
        this.obj2 = new SeqTestClass2();
        this.obj3 = new SeqTestClass2();
        this.obj4 = new SeqTestClass2();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.registerObject((Object)this.obj1);
        SeqTestClass2 clone2 = (SeqTestClass2)uow.registerObject((Object)this.obj2);
        clone2.setPkey(null);
        clone2.setTest1("");
        SeqTestClass2 clone3 = (SeqTestClass2)uow.registerObject((Object)this.obj3);
        clone3.setPkey("a1");
        clone3.setTest1("a1");
        SeqTestClass2 clone4 = (SeqTestClass2)uow.registerObject((Object)this.obj4);
        clone4.setPkey("zzzzzzzzzz");
        clone4.setTest1("zzzzzzzzzz");
        uow.commit();
    }

    protected void verify() throws Exception {
        if (this.obj1.getPkey() == null) {
            throw new TestErrorException("Has not assigned seq string to an object with no pk");
        }
        if (this.obj2.getPkey().equals("")) {
            throw new TestErrorException("Has not overridden an empty string");
        }
        if (this.obj3.getPkey().equals("1")) {
            throw new TestErrorException("Has overridden a valid PK");
        }
        if (!this.obj4.getPkey().equals("zzzzzzzzzz")) {
            throw new TestErrorException("Has overridden a valid PK");
        }
    }

    public void reset() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.deleteObject((Object)this.obj1);
        uow.deleteObject((Object)this.obj2);
        uow.deleteObject((Object)this.obj3);
        uow.deleteObject((Object)this.obj4);
        uow.commit();
        this.obj1 = null;
        this.obj2 = null;
        this.obj3 = null;
        this.obj4 = null;
        this.getSession().getPlatform().setDefaultSequence(this.originalSequence);
        ((DatabaseSession)this.getSession()).getSequencingControl().resetSequencing();
    }
}

