/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.transparentindirection.jdk8;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.descriptors.changetracking.MapChangeEvent;
import org.eclipse.persistence.indirection.IndirectCollectionsFactory;
import org.eclipse.persistence.indirection.IndirectMap;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.indirection.QueryBasedValueHolder;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.testing.tests.transparentindirection.TestSession;
import org.eclipse.persistence.testing.tests.transparentindirection.ZTestCase;
import org.eclipse.persistence.testing.tests.transparentindirection.ZTestSuite;

public class IndirectMapTestAPI
extends ZTestCase {
    private Hashtable<String, String> map;
    private IndirectMap<String, String> testMap;
    private Listener testMapLsn;
    private Class<? extends IndirectMap> cls;
    private boolean useListener;

    public IndirectMapTestAPI(String name) {
        this(name, null, true);
    }

    public IndirectMapTestAPI(String name, Class<? extends IndirectMap> cls, boolean useListener) {
        super(name);
        this.cls = cls;
        this.useListener = useListener;
    }

    public static TestSuite getTestSuiteFor(Class<? extends IndirectMap> cls, boolean useListener) {
        ZTestSuite ts = new ZTestSuite("Suite for " + cls.getName() + "(useListener: " + useListener + ")");
        Enumeration tests = ts.methodNamesStartingWithTestFor(IndirectMapTestAPI.class);
        while (tests.hasMoreElements()) {
            ts.addTest((Test)new IndirectMapTestAPI((String)tests.nextElement(), cls, useListener));
        }
        return ts;
    }

    protected void assertElementsEqual(String message, Map expected, Map actual) {
        if (expected == actual) {
            return;
        }
        if (expected.size() != actual.size()) {
            IndirectMapTestAPI.assertTrue((String)this.notEqualsMessage(message, expected, actual), (boolean)false);
        }
        for (Object key : expected.keySet()) {
            if (expected.get(key).equals(actual.get(key))) continue;
            IndirectMapTestAPI.assertTrue((String)this.notEqualsMessage(message, expected, actual), (boolean)false);
        }
    }

    protected void assertElementsEqual(Map expected, Map actual) {
        this.assertElementsEqual("", expected, actual);
    }

    @Override
    protected void setUp() {
        super.setUp();
        this.map = this.setUpMap();
        Hashtable<String, String> temp = new Hashtable<String, String>(this.map);
        QueryBasedValueHolder vh = new QueryBasedValueHolder((ReadQuery)new ReadAllQuery(), (AbstractRecord)new DatabaseRecord(), (AbstractSession)new TestSession(temp));
        if (this.cls == null) {
            this.testMap = IndirectCollectionsFactory.createIndirectMap();
        } else {
            try {
                this.testMap = this.cls.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
        this.testMap.setValueHolder((ValueHolderInterface)vh);
        if (this.useListener) {
            this.testMapLsn = new Listener();
            this.testMap._persistence_setPropertyChangeListener((PropertyChangeListener)this.testMapLsn);
        }
    }

    protected Hashtable<String, String> setUpMap() {
        Hashtable<String, String> result = new Hashtable<String, String>();
        result.put("zero", "000");
        result.put("one", "111");
        result.put("two", "222");
        result.put("three", "333");
        result.put("four", "444");
        result.put("five", "555");
        result.put("six", "666");
        result.put("seven", "777");
        result.put("eight", "888");
        result.put("nine", "999");
        return result;
    }

    @Override
    protected void tearDown() {
        super.tearDown();
        if (this.useListener) {
            this.testMapLsn.events.clear();
        }
    }

    public void testKeySetRemoveIf() {
        Set<String> keySet = this.map.keySet();
        Set testKeySet = this.testMap.keySet();
        boolean result1 = keySet.removeIf(key -> key.startsWith("s"));
        boolean result2 = testKeySet.removeIf(key -> key.startsWith("s"));
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        IndirectMapTestAPI.assertEquals((boolean)result1, (boolean)result2);
        IndirectMapTestAPI.assertNull((Object)this.testMap.get((Object)"six"));
        this.assertRemoveEvents(2);
    }

    public void testEntrySetRemoveIf() {
        Set<Map.Entry<String, String>> entrySet = this.map.entrySet();
        Set testEntrySet = this.testMap.entrySet();
        boolean result1 = entrySet.removeIf(entry -> "one".equals(entry.getKey()));
        boolean result2 = testEntrySet.removeIf(entry -> "one".equals(entry.getKey()));
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        IndirectMapTestAPI.assertEquals((boolean)result1, (boolean)result2);
        IndirectMapTestAPI.assertNull((Object)this.testMap.get((Object)"one"));
        this.assertRemoveEvents(1);
    }

    public void testValuesRemoveIf() {
        Collection<String> keySet = this.map.values();
        Collection testKeySet = this.testMap.values();
        boolean result1 = keySet.removeIf(key -> key.startsWith("2"));
        boolean result2 = testKeySet.removeIf(key -> key.startsWith("2"));
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        IndirectMapTestAPI.assertEquals((boolean)result1, (boolean)result2);
        IndirectMapTestAPI.assertNull((Object)this.testMap.get((Object)"two"));
        this.assertRemoveEvents(1);
    }

    public void testReplace() {
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        Object o = this.testMap.replace((Object)"one", (Object)"1");
        IndirectMapTestAPI.assertEquals((Object)this.map.replace("one", "1"), (Object)o);
        IndirectMapTestAPI.assertNotNull((String)"Should return value", (Object)o);
        IndirectMapTestAPI.assertEquals((Object)"111", (Object)o);
        IndirectMapTestAPI.assertEquals((String)"1", (String)((String)this.testMap.get((Object)"one")));
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        this.assertRemoveAddEvents(1);
        IndirectMapTestAPI.assertNull((Object)this.map.replace("blablablabla", "whatever"));
        IndirectMapTestAPI.assertNull((Object)this.testMap.replace((Object)"blablablabla", (Object)"whatever"));
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        this.assertRemoveAddEvents(1);
    }

    public void testReplaceWithDefault() {
        IndirectMapTestAPI.assertEquals((String)"111", (String)((String)this.testMap.get((Object)"one")));
        Boolean o = this.testMap.replace((Object)"one", (Object)"1", (Object)"1234");
        IndirectMapTestAPI.assertEquals((Object)this.map.replace("one", "1", "1234"), (Object)o);
        IndirectMapTestAPI.assertFalse((String)"Should return false", (boolean)o);
        IndirectMapTestAPI.assertFalse((String)"Should not have '1234'", (boolean)this.testMap.containsValue((Object)"1234"));
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        this.assertNoEvents();
        IndirectMapTestAPI.assertEquals((String)"111", (String)((String)this.testMap.get((Object)"one")));
        o = this.testMap.replace((Object)"one", (Object)"111", (Object)"1234");
        IndirectMapTestAPI.assertEquals((Object)this.map.replace("one", "111", "1234"), (Object)o);
        IndirectMapTestAPI.assertTrue((String)"Should return true", (boolean)o);
        IndirectMapTestAPI.assertEquals((String)"1234", (String)((String)this.testMap.get((Object)"one")));
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        this.assertRemoveAddEvents(1);
    }

    public void testGetOrDefault() {
        IndirectMapTestAPI.assertFalse((boolean)this.testMap.containsKey((Object)"temp"));
        Object o = this.testMap.getOrDefault((Object)"temp", (Object)"1234");
        IndirectMapTestAPI.assertNotNull((String)"Should return value", (Object)o);
        IndirectMapTestAPI.assertEquals((Object)"1234", (Object)o);
        IndirectMapTestAPI.assertTrue((boolean)this.testMap.containsKey((Object)"one"));
        o = this.testMap.getOrDefault((Object)"one", (Object)"5678");
        IndirectMapTestAPI.assertNotNull((String)"Should return value", (Object)o);
        IndirectMapTestAPI.assertEquals((Object)"111", (Object)o);
        this.assertNoEvents();
    }

    public void testPutIfAbsent() {
        IndirectMapTestAPI.assertFalse((boolean)this.testMap.containsKey((Object)"temp"));
        Object o = this.testMap.putIfAbsent((Object)"temp", (Object)"1234");
        IndirectMapTestAPI.assertNull((String)"Should return null", (Object)o);
        this.assertAddEvents(1);
        IndirectMapTestAPI.assertTrue((boolean)this.testMap.containsKey((Object)"temp"));
        o = this.testMap.putIfAbsent((Object)"temp", (Object)"5678");
        IndirectMapTestAPI.assertNotNull((String)"Should return value", (Object)o);
        IndirectMapTestAPI.assertEquals((Object)"1234", (Object)o);
        this.assertAddEvents(1);
    }

    public void testRemoveTwoArgs() {
        IndirectMapTestAPI.assertEquals((String)"111", (String)((String)this.testMap.get((Object)"one")));
        Boolean o = this.testMap.remove((Object)"one", (Object)"1234");
        IndirectMapTestAPI.assertFalse((String)"Should return false", (boolean)o);
        this.assertNoEvents();
        IndirectMapTestAPI.assertEquals((String)"111", (String)((String)this.testMap.get((Object)"one")));
        o = this.testMap.remove((Object)"one", (Object)"111");
        IndirectMapTestAPI.assertTrue((String)"Should return true", (boolean)o);
        IndirectMapTestAPI.assertNull((Object)this.testMap.get((Object)"one"));
        this.assertRemoveEvents(1);
    }

    public void testForEach() {
        Vector v1 = new Vector();
        Vector v2 = new Vector();
        this.map.forEach((k, v) -> {
            v1.add(k);
            v1.add(v);
        });
        this.testMap.forEach((k, v) -> {
            v2.add(k);
            v2.add(v);
        });
        this.assertUnorderedElementsEqual(v1, v2);
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        this.assertNoEvents();
    }

    public void testReplaceAll() {
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        this.map.replaceAll((k, v) -> {
            v = v + "sufix";
            return v;
        });
        this.testMap.replaceAll((k, v) -> {
            v = v + "sufix";
            return v;
        });
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        this.assertRemoveAddEvents(this.testMap.size());
    }

    public void testCompute() {
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        String s1 = this.map.compute("one", (k, v) -> {
            v = v + "suffix";
            return v;
        });
        String s2 = (String)this.testMap.compute((Object)"one", (k, v) -> {
            v = v + "suffix";
            return v;
        });
        IndirectMapTestAPI.assertEquals((String)s1, (String)s2);
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        IndirectMapTestAPI.assertEquals((String)"111suffix", (String)((String)this.testMap.get((Object)"one")));
        this.assertRemoveAddEvents(1);
    }

    public void testCompute2() {
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        String s1 = this.map.compute("notExist", (k, v) -> {
            v = v + "suffix";
            return v;
        });
        String s2 = (String)this.testMap.compute((Object)"notExist", (k, v) -> {
            v = v + "suffix";
            return v;
        });
        IndirectMapTestAPI.assertEquals((String)s1, (String)s2);
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        IndirectMapTestAPI.assertEquals((String)"nullsuffix", (String)((String)this.testMap.get((Object)"notExist")));
        this.assertAddEvents(1);
    }

    public void testComputeIfPresent() {
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        String s1 = this.map.computeIfPresent("one", (k, v) -> {
            v = v + "suffix";
            return v;
        });
        String s2 = (String)this.testMap.computeIfPresent((Object)"one", (k, v) -> {
            v = v + "suffix";
            return v;
        });
        IndirectMapTestAPI.assertEquals((String)s1, (String)s2);
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        IndirectMapTestAPI.assertEquals((String)"111suffix", (String)((String)this.testMap.get((Object)"one")));
        this.assertRemoveAddEvents(1);
    }

    public void testComputeIfPresent2() {
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        String s1 = this.map.computeIfPresent("notExist", (k, v) -> {
            v = v + "suffix";
            return v;
        });
        String s2 = (String)this.testMap.computeIfPresent((Object)"notExist", (k, v) -> {
            v = v + "suffix";
            return v;
        });
        IndirectMapTestAPI.assertEquals((String)s1, (String)s2);
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        IndirectMapTestAPI.assertNull((Object)this.testMap.get((Object)"notExist"));
        this.assertNoEvents();
    }

    public void testComputeIfAbsent() {
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        String s1 = this.map.computeIfAbsent("one", k -> "newitem");
        String s2 = (String)this.testMap.computeIfAbsent((Object)"one", k -> "newitem");
        IndirectMapTestAPI.assertEquals((String)s1, (String)s2);
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        IndirectMapTestAPI.assertEquals((String)"111", (String)((String)this.testMap.get((Object)"one")));
        this.assertNoEvents();
    }

    public void testComputeIfAbsent2() {
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        String s1 = this.map.computeIfAbsent("notExist", k -> "newitem");
        String s2 = (String)this.testMap.computeIfAbsent((Object)"notExist", k -> "newitem");
        IndirectMapTestAPI.assertEquals((String)s1, (String)s2);
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        this.assertAddEvents(1);
    }

    public void testMerge() {
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        String s1 = this.map.merge("one", "custom", String::concat);
        String s2 = (String)this.testMap.merge((Object)"one", (Object)"custom", String::concat);
        IndirectMapTestAPI.assertEquals((String)s1, (String)s2);
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        IndirectMapTestAPI.assertEquals((String)"111custom", (String)((String)this.testMap.get((Object)"one")));
        this.assertRemoveAddEvents(1);
    }

    public void testMerge2() {
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        String s1 = this.map.merge("notExist", "custom", String::concat);
        String s2 = (String)this.testMap.merge((Object)"notExist", (Object)"custom", String::concat);
        IndirectMapTestAPI.assertEquals((String)s1, (String)s2);
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        IndirectMapTestAPI.assertEquals((String)"111", (String)((String)this.testMap.get((Object)"one")));
        this.assertAddEvents(1);
    }

    private void assertNoEvents() {
        if (this.useListener) {
            IndirectMapTestAPI.assertTrue((boolean)this.testMapLsn.events.isEmpty());
        }
    }

    private void assertAddEvents(int count) {
        if (this.useListener) {
            IndirectMapTestAPI.assertEquals((String)"events do not match", (int)count, (int)this.testMapLsn.events.size());
            for (MapChangeEvent cce : this.testMapLsn.events) {
                IndirectMapTestAPI.assertEquals((String)"expected add event", (int)CollectionChangeEvent.ADD, (int)cce.getChangeType());
            }
        }
    }

    private void assertRemoveEvents(int count) {
        if (this.useListener) {
            IndirectMapTestAPI.assertEquals((String)"events do not match", (int)count, (int)this.testMapLsn.events.size());
            for (MapChangeEvent cce : this.testMapLsn.events) {
                IndirectMapTestAPI.assertEquals((String)"expected add event", (int)CollectionChangeEvent.REMOVE, (int)cce.getChangeType());
            }
        }
    }

    private void assertRemoveAddEvents(int count) {
        if (this.useListener) {
            int totalEvents = count * 2;
            IndirectMapTestAPI.assertEquals((String)"events do not match", (int)totalEvents, (int)this.testMapLsn.events.size());
            int i = 0;
            while (i < totalEvents) {
                MapChangeEvent removeEvent = (MapChangeEvent)this.testMapLsn.events.get(i++);
                MapChangeEvent addEvent = (MapChangeEvent)this.testMapLsn.events.get(i++);
                IndirectMapTestAPI.assertEquals((String)"expected remove event", (int)CollectionChangeEvent.REMOVE, (int)removeEvent.getChangeType());
                IndirectMapTestAPI.assertEquals((String)"expected add event", (int)CollectionChangeEvent.ADD, (int)addEvent.getChangeType());
                IndirectMapTestAPI.assertFalse((String)("removed: '" + removeEvent.getNewValue() + "', new: '" + addEvent.getNewValue() + "'"), (boolean)removeEvent.getNewValue().equals(addEvent.getNewValue()));
            }
        }
    }

    private static final class MapEntry<K, V>
    implements Map.Entry<K, V> {
        private K key;
        private V value;

        public MapEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            this.value = value;
            return this.value;
        }
    }

    private static final class Listener
    implements PropertyChangeListener {
        private List<MapChangeEvent> events = new ArrayList<MapChangeEvent>();

        private Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.events.add((MapChangeEvent)evt);
        }
    }
}

