/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo;

import commonj.sdo.DataObject;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.helper.XMLDocument;
import commonj.sdo.impl.ExternalizableDelegator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.helper.SDOHelperContext;
import org.eclipse.persistence.sdo.helper.SDOXMLHelper;

public class SDOResolvable
implements ExternalizableDelegator.Resolvable {
    private static final long serialVersionUID = 2807334877368539299L;
    public static final String DEFAULT_ROOT_ELEMENT_NAME = "dataObject";
    public static final int SDO_HELPER_CONTEXT_ID_IDENTIFIER = 2;
    public static final int SDO_ROOT_OBJECT_IDENTIFIER = 1;
    public static final int SDO_INTERNAL_OBJECT_IDENTIFIER = 0;
    private transient SDODataObject theSDODataObject;
    private transient HelperContext aHelperContext;

    public SDOResolvable() {
        this.aHelperContext = SDOHelperContext.getHelperContext();
    }

    public SDOResolvable(HelperContext aContext) {
        this.aHelperContext = aContext;
    }

    public SDOResolvable(Object target, HelperContext aContext) {
        this.theSDODataObject = (SDODataObject)target;
        this.aHelperContext = aContext;
    }

    public Object readResolve() throws ObjectStreamException {
        return this.theSDODataObject;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        DeflaterOutputStream aGZIPOutputStream = null;
        ByteArrayOutputStream aByteOutputStream = null;
        if (this.theSDODataObject.getContainer() == null) {
            try {
                String identifier = null;
                if (this.aHelperContext.getClass() == SDOHelperContext.class) {
                    identifier = ((SDOHelperContext)this.aHelperContext).getIdentifier();
                }
                if (identifier != null && !identifier.equals("")) {
                    objectOutput.writeByte(2);
                    objectOutput.writeUTF(identifier);
                } else {
                    objectOutput.writeByte(1);
                }
                aByteOutputStream = new ByteArrayOutputStream();
                aGZIPOutputStream = new GZIPOutputStream(aByteOutputStream);
                XMLDocument aDocument = this.aHelperContext.getXMLHelper().createDocument((DataObject)this.theSDODataObject, "commonj.sdo", "sdo:dataObject");
                ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).serialize(aDocument, aGZIPOutputStream, null);
                ((GZIPOutputStream)aGZIPOutputStream).finish();
                aGZIPOutputStream.flush();
                aByteOutputStream.flush();
                byte[] buf = aByteOutputStream.toByteArray();
                objectOutput.writeInt(buf.length);
                objectOutput.write(buf);
            }
            finally {
                if (aGZIPOutputStream != null) {
                    aGZIPOutputStream.close();
                }
                if (aByteOutputStream != null) {
                    aByteOutputStream.close();
                }
            }
        } else {
            objectOutput.writeByte(0);
            String aPath = this.theSDODataObject._getPath();
            objectOutput.writeUTF(aPath);
            objectOutput.writeObject(this.theSDODataObject.getRootObject());
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        ByteArrayInputStream aByteInputStream = null;
        GZIPInputStream aGZIPInputStream = null;
        int dataObjectIdentifier = objectInput.read();
        switch (dataObjectIdentifier) {
            case 0: {
                String xPathString = objectInput.readUTF();
                SDODataObject deserializedDataObject = (SDODataObject)objectInput.readObject();
                this.theSDODataObject = (SDODataObject)deserializedDataObject.get(xPathString);
                break;
            }
            case 1: {
                try {
                    int aStreamLength = objectInput.readInt();
                    byte[] aGZIPByteArray = new byte[aStreamLength];
                    objectInput.readFully(aGZIPByteArray);
                    aByteInputStream = new ByteArrayInputStream(aGZIPByteArray);
                    aGZIPInputStream = new GZIPInputStream(aByteInputStream);
                    XMLDocument aDocument = this.aHelperContext.getXMLHelper().load((InputStream)aGZIPInputStream);
                    this.theSDODataObject = (SDODataObject)aDocument.getRootObject();
                }
                catch (Throwable throwable) {
                    if (aGZIPInputStream != null) {
                        aGZIPInputStream.close();
                    }
                    if (aByteInputStream != null) {
                        aByteInputStream.close();
                    }
                    throw throwable;
                }
                if (aGZIPInputStream != null) {
                    aGZIPInputStream.close();
                }
                if (aByteInputStream == null) break;
                aByteInputStream.close();
                break;
            }
            case 2: {
                try {
                    String helperContextIdentifier = objectInput.readUTF();
                    int aStreamLength = objectInput.readInt();
                    byte[] aGZIPByteArray = new byte[aStreamLength];
                    objectInput.readFully(aGZIPByteArray);
                    aByteInputStream = new ByteArrayInputStream(aGZIPByteArray);
                    aGZIPInputStream = new GZIPInputStream(aByteInputStream);
                    HelperContext contextToUse = SDOHelperContext.getHelperContext(helperContextIdentifier);
                    XMLDocument aDocument = contextToUse.getXMLHelper().load((InputStream)aGZIPInputStream);
                    this.theSDODataObject = (SDODataObject)aDocument.getRootObject();
                }
                catch (Throwable throwable) {
                    if (aGZIPInputStream != null) {
                        aGZIPInputStream.close();
                    }
                    if (aByteInputStream != null) {
                        aByteInputStream.close();
                    }
                    throw throwable;
                }
                if (aGZIPInputStream != null) {
                    aGZIPInputStream.close();
                }
                if (aByteInputStream == null) break;
                aByteInputStream.close();
            }
        }
    }

    public HelperContext getHelperContext() {
        return this.aHelperContext;
    }

    public void setHelperContext(HelperContext helperContext) {
        this.aHelperContext = helperContext;
    }
}

