/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.weaving;

import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.Map;
import javax.persistence.spi.ClassTransformer;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.weaving.ClassDetails;
import org.eclipse.persistence.internal.jpa.weaving.ClassWeaver;
import org.eclipse.persistence.internal.jpa.weaving.ComputeClassWriter;
import org.eclipse.persistence.internal.libraries.asm.ClassReader;
import org.eclipse.persistence.internal.libraries.asm.ClassVisitor;
import org.eclipse.persistence.internal.libraries.asm.ClassWriter;
import org.eclipse.persistence.internal.libraries.asm.commons.SerialVersionUIDAdder;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.Session;

public class PersistenceWeaver
implements ClassTransformer {
    public static final String EXCEPTION_WHILE_WEAVING = "exception_while_weaving";
    protected Session session;
    protected Map classDetailsMap;

    public PersistenceWeaver(Session session, Map classDetailsMap) {
        this.session = session;
        this.classDetailsMap = classDetailsMap;
    }

    public void clear() {
        this.session = null;
        this.classDetailsMap = null;
    }

    public Map getClassDetailsMap() {
        return this.classDetailsMap;
    }

    public byte[] transform(ClassLoader loader, String className, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        block11: {
            ClassWeaver classWeaver;
            Object classWriter;
            Session session;
            block12: {
                Map classDetailsMap = this.classDetailsMap;
                session = this.session;
                if (classDetailsMap == null || session == null) {
                    return null;
                }
                ClassDetails classDetails = (ClassDetails)classDetailsMap.get(Helper.toSlashedClassName((String)className));
                if (classDetails == null) break block11;
                ((AbstractSession)session).log(1, "weaver", "begin_weaving_class", (Object)className);
                ClassReader classReader = new ClassReader(classfileBuffer);
                classWriter = null;
                String introspectForHierarchy = PrivilegedAccessHelper.getSystemProperty((String)"eclipselink.weaving.reflective-introspection", null);
                classWriter = introspectForHierarchy != null ? new ClassWriter(2) : new ComputeClassWriter(loader, 2);
                classWeaver = new ClassWeaver((ClassVisitor)classWriter, classDetails);
                SerialVersionUIDAdder sv = new SerialVersionUIDAdder((ClassVisitor)classWeaver);
                classReader.accept((ClassVisitor)sv, 0);
                if (!classWeaver.alreadyWeaved) break block12;
                ((AbstractSession)session).log(1, "weaver", "end_weaving_class", (Object)className);
                return null;
            }
            try {
                if (classWeaver.weaved) {
                    byte[] bytes = classWriter.toByteArray();
                    String outputPath = PrivilegedAccessHelper.getSystemProperty((String)"eclipselink.weaving.output.path", (String)"");
                    if (!outputPath.equals("")) {
                        Helper.outputClassFile((String)className, (byte[])bytes, (String)outputPath);
                    }
                    if (classWeaver.weavedPersistenceEntity) {
                        ((AbstractSession)session).log(1, "weaver", "weaved_persistenceentity", (Object)className);
                    }
                    if (classWeaver.weavedChangeTracker) {
                        ((AbstractSession)session).log(1, "weaver", "weaved_changetracker", (Object)className);
                    }
                    if (classWeaver.weavedLazy) {
                        ((AbstractSession)session).log(1, "weaver", "weaved_lazy", (Object)className);
                    }
                    if (classWeaver.weavedFetchGroups) {
                        ((AbstractSession)session).log(1, "weaver", "weaved_fetchgroups", (Object)className);
                    }
                    if (classWeaver.weavedRest) {
                        ((AbstractSession)session).log(1, "weaver", "weaved_rest", (Object)className);
                    }
                    ((AbstractSession)session).log(1, "weaver", "end_weaving_class", (Object)className);
                    return bytes;
                }
                ((AbstractSession)session).log(1, "weaver", "end_weaving_class", (Object)className);
            }
            catch (Throwable exception) {
                ((AbstractSession)session).log(6, "weaver", EXCEPTION_WHILE_WEAVING, (Object)className, (Object)exception);
                ((AbstractSession)session).logThrowable(1, "weaver", exception);
            }
        }
        return null;
    }

    protected static String getShortName(String name) {
        int pos = name.lastIndexOf(47);
        if (pos >= 0) {
            if ((name = name.substring(pos + 1)).endsWith(";")) {
                name = name.substring(0, name.length() - 1);
            }
            return name;
        }
        return "";
    }
}

