/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.clientserver;

import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.clientserver.AnotherClient;
import org.eclipse.persistence.testing.tests.clientserver.Client;
import org.eclipse.persistence.testing.tests.clientserver.Server;

public class ClientServerTest
extends TestCase {
    protected DatabaseLogin login;
    protected Client[] clients = new Client[3];
    protected AnotherClient[] moreClients = new AnotherClient[15];
    protected Server server;

    public ClientServerTest() {
        this.setDescription("The test simulates the client/serve by spawning clients in the thread");
    }

    public void reset() {
        try {
            this.clients[0].release();
            this.clients[1].release();
            this.clients[2].release();
            for (int index = 0; index < 15; ++index) {
                this.moreClients[index].release();
            }
            this.server.logout();
            this.getDatabaseSession().logout();
            this.getDatabaseSession().login();
        }
        catch (ValidationException ex) {
            this.verify();
        }
    }

    public void setup() {
        try {
            this.login = (DatabaseLogin)this.getSession().getLogin().clone();
            this.server = new Server(this.login);
            this.server.serverSession.setSessionLog(this.getSession().getSessionLog());
            this.server.login();
            this.server.copyDescriptors(this.getSession());
            this.clients[0] = new Client(this.server, "Smith", this.getSession());
            this.clients[1] = new Client(this.server, "Way", this.getSession());
            this.clients[2] = new Client(this.server, "Chanley", this.getSession());
            for (int index = 0; index < 15; ++index) {
                this.moreClients[index] = new AnotherClient(this.server, index, this.getSession());
            }
        }
        catch (ValidationException ex) {
            this.verify();
        }
    }

    public void test() {
        try {
            int index;
            this.clients[0].start();
            this.clients[1].start();
            this.clients[2].start();
            for (index = 0; index < 15; ++index) {
                this.moreClients[index].start();
            }
            try {
                this.clients[0].join();
                this.clients[1].join();
                this.clients[2].join();
                for (index = 0; index < 15; ++index) {
                    this.moreClients[index].join();
                }
            }
            catch (InterruptedException exception) {
                TestErrorException testException = new TestErrorException("Client threads are interrupted");
                testException.setInternalException((Throwable)exception);
                throw testException;
            }
        }
        catch (ValidationException ex) {
            this.verify();
        }
    }

    public void verify() {
        block6: {
            try {
                if (this.server.errorOccured) {
                    throw new TestErrorException("An error occurred on one of the clients, check System.out.");
                }
                this.getExecutor().getSession().getIdentityMapAccessor().initializeIdentityMaps();
                Expression exp = new ExpressionBuilder().get("lastName").equal((Object)"Smith");
                Object objectToVerify = this.getSession().readObject(Employee.class, exp);
                if (!this.compareObjects(objectToVerify, this.clients[0].objectToBeWritten)) {
                    throw new TestErrorException("Object was not written properly to the database");
                }
                exp = new ExpressionBuilder().get("lastName").equal((Object)"Way");
                objectToVerify = this.getSession().readObject(Employee.class, exp);
                if (!this.compareObjects(objectToVerify, this.clients[1].objectToBeWritten)) {
                    throw new TestErrorException("Object was not written properly to the database");
                }
                exp = new ExpressionBuilder().get("lastName").equal((Object)"Chanley");
                objectToVerify = this.getSession().readObject(Employee.class, exp);
                if (!this.compareObjects(objectToVerify, this.clients[2].objectToBeWritten)) {
                    throw new TestErrorException("Object was not written properly to the database");
                }
            }
            catch (ValidationException ex) {
                if (ex.getErrorCode() == 7090) break block6;
                throw ex;
            }
        }
    }
}

