/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.readonly;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.readonly.Address;
import org.eclipse.persistence.testing.models.readonly.Country;

public class ReadOnlyClassDeepMergeCloneTest
extends AutoVerifyTestCase {
    public Address address;

    public void reset() {
        this.getSession().getProject().setDefaultReadOnlyClasses(new Vector());
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    protected void test() {
        Vector countries = this.getSession().readAllObjects(Country.class);
        Vector<Class<Country>> readOnlyClasses = new Vector<Class<Country>>();
        readOnlyClasses.addElement(Country.class);
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.removeAllReadOnlyClasses();
        uow.addReadOnlyClasses(readOnlyClasses);
        ExpressionBuilder expBuilder = new ExpressionBuilder();
        Expression exp = expBuilder.get("country").get("name").equal((Object)"United Kingdom");
        this.address = (Address)this.getSession().readObject(Address.class, exp);
        Address addressClone = (Address)uow.registerObject((Object)this.address);
        Address serializedAddress = null;
        try {
            ByteArrayOutputStream outArray = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(outArray);
            out.writeObject(addressClone);
            ByteArrayInputStream inArray = new ByteArrayInputStream(outArray.toByteArray());
            ObjectInputStream in = new ObjectInputStream(inArray);
            serializedAddress = (Address)in.readObject();
        }
        catch (Exception ex) {
            throw new TestErrorException("Test not run failed to serialize objects:" + ex.toString());
        }
        uow.deepMergeClone((Object)serializedAddress);
        if (addressClone.getCountry() == serializedAddress.getCountry()) {
            throw new TestErrorException("Deepmerge clone merge lost object identity for readonly object");
        }
    }
}

