/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.sop;

import org.eclipse.persistence.internal.descriptors.SerializedObjectPolicyWrapper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;

public class SerializedObjectPolicyMetadata
extends ORMetadata {
    protected MetadataClass m_class;
    protected String m_className;
    protected ColumnMetadata m_column;

    public SerializedObjectPolicyMetadata() {
        super("<serialized-object>");
    }

    public SerializedObjectPolicyMetadata(MetadataAnnotation serializedObject, MetadataAccessor accessor) {
        super(serializedObject, accessor);
        this.m_class = this.getMetadataClass(serializedObject.getAttributeString("value"));
        MetadataAnnotation column = serializedObject.getAttributeAnnotation("column");
        this.m_column = new ColumnMetadata(column, accessor);
        if (column == null) {
            this.m_column.setName("SOP");
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof SerializedObjectPolicyMetadata) {
            SerializedObjectPolicyMetadata serializedObjectToCompare = (SerializedObjectPolicyMetadata)objectToCompare;
            return this.valuesMatch(this.m_className, serializedObjectToCompare.getClassName()) && this.valuesMatch(this.m_column, serializedObjectToCompare.getColumn());
        }
        return false;
    }

    public String getClassName() {
        return this.m_className;
    }

    public ColumnMetadata getColumn() {
        return this.m_column;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.m_class = this.initXMLClassName(this.m_className);
        this.initXMLObject(this.m_column, accessibleObject);
        if (this.m_column == null) {
            this.m_column = new ColumnMetadata();
            this.m_column.setName("SOP");
        }
    }

    public void process(MetadataDescriptor descriptor) {
        descriptor.setHasSerializedObjectPolicy();
        SerializedObjectPolicyWrapper sop = new SerializedObjectPolicyWrapper(this.m_class.getName());
        sop.setField(this.m_column.getDatabaseField());
        descriptor.getClassDescriptor().setSerializedObjectPolicy(sop);
    }

    public void setClassName(String className) {
        this.m_className = className;
    }

    public void setColumn(ColumnMetadata column) {
        this.m_column = column;
    }
}

