/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.oracleddl.metadata;

import org.eclipse.persistence.tools.oracleddl.metadata.ArgumentType;
import org.eclipse.persistence.tools.oracleddl.metadata.ProcedureType;
import org.eclipse.persistence.tools.oracleddl.metadata.visit.DatabaseTypeVisitor;

public class FunctionType
extends ProcedureType {
    protected ArgumentType returnArgument;

    public FunctionType(String procedureName) {
        super(procedureName);
    }

    @Override
    public void setProcedureName(String procedureName) {
        this.procedureName = procedureName;
        this.typeName = "FUNCTION " + procedureName;
    }

    public ArgumentType getReturnArgument() {
        return this.returnArgument;
    }

    public void setReturnArgument(ArgumentType returnArgument) {
        this.returnArgument = returnArgument;
    }

    @Override
    public boolean isResolved() {
        if (this.returnArgument == null) {
            return false;
        }
        if (!this.returnArgument.isResolved()) {
            return false;
        }
        return super.isResolved();
    }

    @Override
    public boolean isFunctionType() {
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("FUNCTION ");
        if (this.schema != null) {
            sb.append(this.schema);
            sb.append(".");
        }
        sb.append(this.procedureName);
        sb.append("(");
        int i = 0;
        while (i < this.arguments.size()) {
            ArgumentType arg = (ArgumentType)this.arguments.get(i);
            sb.append(arg.toString());
            if (++i >= this.arguments.size()) continue;
            sb.append(", ");
        }
        sb.append(") ");
        sb.append(this.returnArgument != null ? this.returnArgument.toString() : "<NULL>");
        return sb.toString();
    }

    @Override
    public void accept(DatabaseTypeVisitor visitor) {
        visitor.visit(this);
    }
}

