/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.dynamic.sessionsxml;

import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicTypeBuilder;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.factories.SessionsFactory;
import org.eclipse.persistence.internal.sessions.factories.XMLSessionConfigProject_11_1_1;
import org.eclipse.persistence.internal.sessions.factories.model.SessionConfigs;
import org.eclipse.persistence.internal.sessions.factories.model.login.LoginConfig;
import org.eclipse.persistence.internal.sessions.factories.model.project.ProjectConfig;
import org.eclipse.persistence.internal.sessions.factories.model.session.SessionConfig;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.sessions.factories.XMLSessionConfigLoader;
import org.eclipse.persistence.testing.tests.dynamic.DynamicTestingHelper;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ComicsConfigTestSuite {
    public static final String PACKAGE_PATH = ComicsConfigTestSuite.class.getPackage().getName().replace('.', '/');
    public static final String COMICS_SESSION_XML = PACKAGE_PATH + "/sessions.xml";
    public static final String COMICS_SESSION_NAME = "dynamic-comics";
    static DatabaseSession session = null;

    @BeforeClass
    public static void setUp() {
        session = ComicsConfigTestSuite.buildComicsSession();
        Assert.assertNotNull((Object)session);
    }

    public static DatabaseSession buildComicsSession() {
        DynamicClassLoader dcl = new DynamicClassLoader(ComicsConfigTestSuite.class.getClassLoader());
        new DynamicTypeBuilder(dcl.createDynamicClass("model.Issue"), null, new String[0]);
        new DynamicTypeBuilder(dcl.createDynamicClass("model.Publisher"), null, new String[0]);
        new DynamicTypeBuilder(dcl.createDynamicClass("model.Title"), null, new String[0]);
        XMLSessionConfigLoader loader = new XMLSessionConfigLoader(COMICS_SESSION_XML){

            public boolean load(SessionManager sessionManager, ClassLoader loader) {
                Document document = this.loadDocument(loader);
                if (this.getExceptionStore().isEmpty() && document.getDocumentElement().getTagName().equals("sessions")) {
                    XMLContext context = new XMLContext((Project)new XMLSessionConfigProject_11_1_1());
                    XMLUnmarshaller unmarshaller = context.createUnmarshaller();
                    SessionConfigs configs = (SessionConfigs)unmarshaller.unmarshal((Node)document);
                    SessionsFactory factory = new SessionsFactory(){

                        protected Project loadProjectConfig(ProjectConfig projectConfig) {
                            if (projectConfig.isProjectXMLConfig()) {
                                projectConfig.setProjectString(PACKAGE_PATH + "/" + projectConfig.getProjectString());
                            }
                            return super.loadProjectConfig(projectConfig);
                        }

                        protected Login buildLogin(LoginConfig loginConfig) {
                            return DynamicTestingHelper.createLogin();
                        }

                        protected AbstractSession buildSession(SessionConfig sessionConfig) {
                            AbstractSession s = super.buildSession(sessionConfig);
                            if (8 == DynamicTestingHelper.logLevel) {
                                s.dontLogMessages();
                            } else {
                                s.setLogLevel(DynamicTestingHelper.logLevel);
                            }
                            return s;
                        }
                    };
                    Map sessions = factory.buildSessionConfigs(configs, loader);
                    for (Map.Entry entry : sessions.entrySet()) {
                        if (sessionManager.getSessions().containsKey(entry.getKey())) continue;
                        sessionManager.addSession((String)entry.getKey(), (Session)entry.getValue());
                    }
                    return true;
                }
                return false;
            }
        };
        loader.setClassLoader((ClassLoader)dcl);
        loader.setSessionName(COMICS_SESSION_NAME);
        return (DatabaseSession)SessionManager.getManager().getSession(loader);
    }

    @Test
    public void verifyDescriptorClasses() {
        ClassDescriptor descriptor = session.getClassDescriptorForAlias("Issue");
        Assert.assertNotNull((Object)descriptor);
        Assert.assertTrue((boolean)DynamicEntity.class.isAssignableFrom(descriptor.getJavaClass()));
        descriptor = session.getClassDescriptorForAlias("Publisher");
        Assert.assertNotNull((Object)descriptor);
        Assert.assertTrue((boolean)DynamicEntity.class.isAssignableFrom(descriptor.getJavaClass()));
        descriptor = session.getClassDescriptorForAlias("Title");
        Assert.assertNotNull((Object)descriptor);
        Assert.assertTrue((boolean)DynamicEntity.class.isAssignableFrom(descriptor.getJavaClass()));
    }
}

