/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.feature;

import java.util.List;
import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.tests.feature.QueryTimeoutBatchTestCase;

public abstract class QueryTimeoutBatchDatabaseQueryTest
extends QueryTimeoutBatchTestCase {
    @Override
    protected int getParentQueryTimeout() {
        return 2;
    }

    @Override
    protected int getChildQueryTimeout() {
        return 2;
    }

    @Override
    protected String getQuerySQLPostfix() {
        return ", SUM(e.address_id) as version from address e, address b, address b, address c, address c, address c, address b";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() {
        UnitOfWork uow = null;
        try {
            uow = this.setupPlatform();
            this.initializeDatabase(uow);
            uow = this.getSession().acquireUnitOfWork();
            int queryCount = 0;
            for (int i = 0; i < this.getNumberOfInserts(); ++i) {
                DataModifyQuery query = new DataModifyQuery();
                ++queryCount;
                StringBuffer sBuffer = new StringBuffer(this.getQuerySQLPrefix());
                sBuffer.append(this.getCurrentIDSequence() + (long)i);
                sBuffer.append(this.getQuerySQLPostfix());
                query.setSQLString(sBuffer.toString());
                query.setQueryTimeout(this.getChildQueryTimeout());
                StringBuilder queryName = new StringBuilder("query");
                queryName.append(i);
                if (queryCount == this.getNumberOfInserts()) {
                    query.setForceBatchStatementExecution(true);
                }
                uow.addQuery(queryName.toString(), (DatabaseQuery)query);
                uow.executeQuery((DatabaseQuery)query);
            }
            uow.commit();
        }
        catch (Exception e) {
            if (e instanceof DatabaseException) {
                this.limitExceeded = true;
                this.vendorErrorCodeEncountered = ((DatabaseException)((Object)e)).getDatabaseErrorCode();
            }
            ((AbstractSession)uow).rollbackTransaction();
        }
        finally {
            this.resetPlatform();
        }
    }

    protected List registerObjects(UnitOfWork uow) {
        return null;
    }

    @Override
    public void setDescriptorLevelQueryTimeout(DescriptorQueryManager queryManager) {
    }

    @Override
    public void setQueryLevelQueryTimeout(UnitOfWork uow, Object object) {
    }
}

