/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.helper;

import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class CompareCharArrayLengthTest
extends AutoVerifyTestCase {
    Exception e;
    char[] array1 = new char[]{'a', 'b'};
    char[] array2 = new char[]{'a', 'b'};
    char[] array3 = new char[]{'a', 'b', 'c'};
    boolean test1ResultIsTrue = false;
    boolean test2ResultIsTrue = false;

    public CompareCharArrayLengthTest() {
        this.setDescription("Test of Helper.compareCharArrays(char[] array1, char[] array2) method's comparison of array length.");
    }

    public static void main(String[] args) {
        CompareCharArrayLengthTest x = new CompareCharArrayLengthTest();
        x.setup();
        x.test();
        x.verify();
        x.reset();
    }

    public void setup() {
    }

    public void test() {
        try {
            this.test1ResultIsTrue = Helper.compareCharArrays((char[])this.array1, (char[])this.array2);
            this.test2ResultIsTrue = Helper.compareCharArrays((char[])this.array1, (char[])this.array3);
        }
        catch (Exception e) {
            this.e = e;
            throw new TestErrorException("An exception should not have been thrown when comparing char array length.");
        }
    }

    public void verify() {
        if (!this.test1ResultIsTrue) {
            throw new TestErrorException("Helper.compareCharArrays(char[] array1, char[] array2) does not recognize that arrays are of same length.");
        }
        if (this.test2ResultIsTrue) {
            throw new TestErrorException("Helper.compareCharArrays(char[] array1, char[] array2) does not recognize that arrays are of different length.");
        }
        if (this.e != null) {
            throw new TestErrorException("An exception should not have been thrown when comparing char array length: " + this.e.toString());
        }
    }

    public void reset() {
        this.array1 = null;
        this.array2 = null;
        this.array3 = null;
    }
}

