/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.descriptors.invalidation.CacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.TimeToLiveCacheInvalidationPolicy;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation.CacheExpiryTest;

public class CacheExpiryAPITest
extends CacheExpiryTest {
    protected String isValidSuccess = null;
    protected boolean invalidateObjectSuccess = true;
    protected boolean invalidateCollectionSuccess = true;
    protected boolean invalidateClassSuccess = true;
    protected long remainingTime = 0L;

    public CacheExpiryAPITest() {
        this.setDescription("Test the specific API for Cache Expiry on the IdentityMapAccessor.");
    }

    @Override
    public void setup() {
        super.setup();
        this.getSession().getDescriptor(Employee.class).setCacheInvalidationPolicy((CacheInvalidationPolicy)new TimeToLiveCacheInvalidationPolicy(10000L));
        this.getSession().readAllObjects(Employee.class);
    }

    public void test() {
        Employee employee = (Employee)this.getSession().readObject(Employee.class);
        boolean validEmployee = this.getAbstractSession().getIdentityMapAccessor().isValid((Object)employee);
        if (this.getValidityFromIdentityMapManager(employee) != validEmployee) {
            this.isValidSuccess = "identityMapAccessor().isValid() did not return true for a valid object.";
            return;
        }
        ((TimeToLiveCacheInvalidationPolicy)this.getSession().getDescriptor(Employee.class).getCacheInvalidationPolicy()).setTimeToLive(-1L);
        validEmployee = this.getAbstractSession().getIdentityMapAccessor().isValid((Object)employee);
        if (this.getValidityFromIdentityMapManager(employee) != validEmployee) {
            this.isValidSuccess = "identityMapAccessor().isValid() did not return false for an invalid object.";
            return;
        }
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.getSession().readAllObjects(Employee.class);
        employee = (Employee)this.getSession().readObject(Employee.class);
        this.getAbstractSession().getIdentityMapAccessor().invalidateObject((Object)employee);
        if (this.getAbstractSession().getIdentityMapAccessor().isValid((Object)employee)) {
            this.invalidateObjectSuccess = false;
            return;
        }
        ExpressionBuilder employees = new ExpressionBuilder();
        Expression exp = employees.get("lastName").equal((Object)"Smith");
        Vector smiths = this.getSession().readAllObjects(Employee.class, exp);
        this.getAbstractSession().getIdentityMapAccessor().invalidateObjects((Collection)smiths);
        Enumeration smithEnum = smiths.elements();
        while (smithEnum.hasMoreElements()) {
            employee = (Employee)smithEnum.nextElement();
            if (!this.getAbstractSession().getIdentityMapAccessor().isValid((Object)employee)) continue;
            this.invalidateCollectionSuccess = false;
            return;
        }
        Vector allEmployees = this.getSession().readAllObjects(Employee.class);
        this.getAbstractSession().getIdentityMapAccessor().invalidateClass(Employee.class);
        Enumeration empEnum = allEmployees.elements();
        while (empEnum.hasMoreElements()) {
            employee = (Employee)empEnum.nextElement();
            if (!this.getAbstractSession().getIdentityMapAccessor().isValid((Object)employee)) continue;
            this.invalidateClassSuccess = false;
            return;
        }
        this.getAbstractSession().getDescriptor(Employee.class).setCacheInvalidationPolicy((CacheInvalidationPolicy)new TimeToLiveCacheInvalidationPolicy(100000L));
        this.getAbstractSession().getIdentityMapAccessor().initializeIdentityMaps();
        employee = (Employee)this.getAbstractSession().readObject(Employee.class);
        this.remainingTime = this.getAbstractSession().getIdentityMapAccessor().getRemainingValidTime((Object)employee);
    }

    public void verify() {
        if (this.isValidSuccess != null) {
            throw new TestErrorException("IsValid() Failed. " + this.isValidSuccess);
        }
        if (!this.invalidateObjectSuccess) {
            throw new TestErrorException("Invalidate Object API call did not correctly invalidate objects.");
        }
        if (!this.invalidateCollectionSuccess) {
            throw new TestErrorException("Invalidate Objects API call did not correctly invalidate objects.");
        }
        if (!this.invalidateClassSuccess) {
            throw new TestErrorException("Invalidate Class API call did not correctly invalidate objects.");
        }
        if (this.remainingTime > 101000L || this.remainingTime < 99000L) {
            throw new TestErrorException("Get Remaining Life API call did not return a reasonable value.  Please check to see that the the system is not so overloaded that the time between 2 lines of java is greater than 1 second.");
        }
    }

    public boolean getValidityFromIdentityMapManager(Object object) {
        CacheKey key = this.getAbstractSession().getIdentityMapAccessorInstance().getCacheKeyForObject(object);
        return !this.getAbstractSession().getDescriptor(object).getCacheInvalidationPolicy().isInvalidated(key, System.currentTimeMillis());
    }
}

