/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.interfaces;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.VariableOneToOneMapping;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.interfaces.Employee;

public class VariableOneToOneGetTypeFieldTest
extends TestCase {
    protected VariableOneToOneMapping contactMapping;
    protected Object valueReturned1;
    protected Object valueReturned2;

    public VariableOneToOneGetTypeFieldTest() {
        this.setDescription("Verify VariableOneToOneMapping returns the configured type field value when passed a type field");
    }

    public void setup() {
        ClassDescriptor employeeDescriptor = this.getSession().getClassDescriptor(Employee.class);
        VariableOneToOneGetTypeFieldTest.assertNotNull((Object)employeeDescriptor);
        this.contactMapping = (VariableOneToOneMapping)employeeDescriptor.getMappingForAttributeName("contact");
        VariableOneToOneGetTypeFieldTest.assertNotNull((Object)this.contactMapping);
    }

    public void test() {
        this.valueReturned1 = this.contactMapping.valueFromObject((Object)Employee.example1(), this.contactMapping.getTypeField(), (AbstractSession)this.getSession());
        this.valueReturned2 = this.contactMapping.valueFromObject((Object)Employee.example3(), new DatabaseField(this.contactMapping.getTypeFieldName()), (AbstractSession)this.getSession());
    }

    public void verify() {
        Class<?> actualClass = Employee.example1().getContact().getClass();
        Object actualValue = this.contactMapping.getTypeIndicatorTranslation().get(actualClass);
        VariableOneToOneGetTypeFieldTest.assertNotNull((String)"VariableOneToOne type value 'valueReturned1' should not be null", (Object)this.valueReturned1);
        VariableOneToOneGetTypeFieldTest.assertEquals((String)"Incorrect value returned for type field value", actualValue, (Object)this.valueReturned1);
        actualClass = Employee.example3().getContact().getClass();
        actualValue = this.contactMapping.getTypeIndicatorTranslation().get(actualClass);
        VariableOneToOneGetTypeFieldTest.assertNotNull((String)"VariableOneToOne type value 'valueReturned2' should not be null", (Object)this.valueReturned2);
        VariableOneToOneGetTypeFieldTest.assertEquals((String)"Incorrect value returned for type field value", actualValue, (Object)this.valueReturned2);
    }

    public void reset() {
        this.valueReturned1 = null;
        this.valueReturned2 = null;
    }
}

