/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.nls.japanese;

import java.io.Serializable;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.sql.Time;
import java.util.Vector;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.sessions.Record;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.EmploymentPeriod;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;
import org.eclipse.persistence.testing.models.employee.interfaces.Employee;
import org.eclipse.persistence.testing.models.employee.interfaces.Project;

public class NLSEmployee
implements Employee,
Serializable {
    public BigDecimal id;
    public String firstName = "";
    public String lastName = "";
    public String gender;
    public EmploymentPeriod period;
    public ValueHolderInterface address = new ValueHolder();
    public ValueHolderInterface manager = new ValueHolder();
    public ValueHolderInterface managedEmployees = new ValueHolder(new Vector());
    public ValueHolderInterface phoneNumbers;
    public ValueHolderInterface projects = new ValueHolder(new Vector());
    public ValueHolderInterface responsibilitiesList = new ValueHolder(new Vector());
    public Time[] normalHours;
    public int salary;

    public NLSEmployee() {
        this.phoneNumbers = new ValueHolder(new Vector());
        this.normalHours = new Time[]{Helper.timeFromHourMinuteSecond((int)9, (int)0, (int)0), Helper.timeFromHourMinuteSecond((int)17, (int)0, (int)0)};
    }

    @Override
    public void addManagedEmployee(Employee employee) {
        this.getManagedEmployees().addElement(employee);
        employee.setManager(this);
    }

    @Override
    public void addPhoneNumber(PhoneNumber phoneNumber) {
        this.getPhoneNumbers().addElement(phoneNumber);
        phoneNumber.setOwner(this);
    }

    @Override
    public void addProject(Project project) {
        this.getProjects().addElement(project);
    }

    @Override
    public void addResponsibility(String responsibility) {
        this.getResponsibilitiesList().addElement(responsibility);
    }

    public Time[] buildNormalHours(Record row, Session session) {
        Time[] hours = new Time[]{(Time)session.getPlatform().convertObject(row.get((Object)"\u3066\u3068\u3042\u3064\u3068_\u3068\u3051\u3059\u304a"), Time.class), (Time)session.getPlatform().convertObject(row.get((Object)"\u304a\u305b\u3048_\u3068\u3051\u3059\u304a"), Time.class)};
        return hours;
    }

    @Override
    public Address getAddress() {
        return (Address)this.address.getValue();
    }

    @Override
    public Time getEndTime() {
        return this.getNormalHours()[1];
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public String getGender() {
        return this.gender;
    }

    @Override
    public BigDecimal getId() {
        return this.id;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public Vector getManagedEmployees() {
        return (Vector)this.managedEmployees.getValue();
    }

    @Override
    public Employee getManager() {
        return (NLSEmployee)this.manager.getValue();
    }

    @Override
    public Time[] getNormalHours() {
        return this.normalHours;
    }

    @Override
    public EmploymentPeriod getPeriod() {
        return this.period;
    }

    @Override
    public Vector getPhoneNumbers() {
        return (Vector)this.phoneNumbers.getValue();
    }

    @Override
    public Vector getProjects() {
        return (Vector)this.projects.getValue();
    }

    @Override
    public Vector getResponsibilitiesList() {
        return (Vector)this.responsibilitiesList.getValue();
    }

    @Override
    public int getSalary() {
        return this.salary;
    }

    @Override
    public Time getStartTime() {
        return this.getNormalHours()[0];
    }

    @Override
    public void removeManagedEmployee(Employee employee) {
        this.getManagedEmployees().removeElement(employee);
        employee.setManager(null);
    }

    @Override
    public void removePhoneNumber(PhoneNumber phoneNumber) {
        this.getPhoneNumbers().removeElement(phoneNumber);
    }

    @Override
    public void removeProject(Project project) {
        this.getProjects().removeElement(project);
    }

    @Override
    public void removeResponsibility(String responsibility) {
        this.getResponsibilitiesList().removeElement(responsibility);
    }

    @Override
    public void setAddress(Address address) {
        this.address.setValue((Object)address);
    }

    @Override
    public void setEndTime(Time endTime) {
        this.getNormalHours()[1] = endTime;
    }

    @Override
    public void setFemale() {
        this.setGender("Female");
    }

    @Override
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Override
    public void setGender(String gender) {
        this.gender = gender;
    }

    public void setId(BigDecimal id) {
        this.id = id;
    }

    @Override
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Override
    public void setMale() {
        this.setGender("Male");
    }

    @Override
    public void setManagedEmployees(Vector managedEmployees) {
        this.managedEmployees.setValue((Object)managedEmployees);
    }

    @Override
    public void setManager(Employee manager) {
        this.manager.setValue((Object)manager);
    }

    @Override
    public void setNormalHours(Time[] normalHours) {
        this.normalHours = normalHours;
    }

    @Override
    public void setPeriod(EmploymentPeriod period) {
        this.period = period;
    }

    @Override
    public void setPhoneNumbers(Vector phoneNumbers) {
        this.phoneNumbers.setValue((Object)phoneNumbers);
    }

    @Override
    public void setProjects(Vector projects) {
        this.projects.setValue((Object)projects);
    }

    @Override
    public void setResponsibilitiesList(Vector responsibilitiesList) {
        this.responsibilitiesList.setValue((Object)responsibilitiesList);
    }

    @Override
    public void setSalary(int salary) {
        this.salary = salary;
    }

    @Override
    public void setStartTime(Time startTime) {
        this.getNormalHours()[0] = startTime;
    }

    @Override
    public String toString() {
        StringWriter writer = new StringWriter();
        writer.write("Employee: ");
        writer.write(this.getFirstName());
        writer.write(" ");
        writer.write(this.getLastName());
        return writer.toString();
    }
}

