/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.inmemory;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class MemoryQueryAcrossDirectCollectionMapping
extends AutoVerifyTestCase {
    protected Employee employee;
    protected ReadAllQuery queryAll;
    protected ReadAllQuery queryObjects;
    protected ReadObjectQuery queryObject;
    protected Vector allEmployees;
    protected Vector employees;

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
        this.allEmployees = new Vector();
        this.employees = new Vector();
        this.queryAll = new ReadAllQuery();
        this.queryAll.setReferenceClass(Employee.class);
        this.queryAll.setSelectionCriteria(new ExpressionBuilder().anyOf("responsibilitiesList").greaterThan((Object)"Awol"));
        this.getSession().removeQuery("getAllEmployees");
        this.getSession().addQuery("getAllEmployees", (DatabaseQuery)this.queryAll);
        this.allEmployees = (Vector)this.getSession().executeQuery("getAllEmployees");
        Enumeration enumtr = this.allEmployees.elements();
        while (enumtr.hasMoreElements()) {
            Vector response = ((Employee)enumtr.nextElement()).getResponsibilitiesList();
            this.employees.addAll(response);
        }
    }

    public void test() {
        this.queryObjects = new ReadAllQuery();
        this.queryObjects.setReferenceClass(Employee.class);
        this.queryObjects.checkCacheOnly();
        ExpressionBuilder bldr = new ExpressionBuilder();
        Expression exp = bldr.anyOf("responsibilitiesList").equal((Object)"Make the coffee.");
        this.queryObjects.setSelectionCriteria(exp);
        this.employees = (Vector)this.getSession().executeQuery((DatabaseQuery)this.queryObjects);
    }
}

