/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.sessionsxml;

import org.eclipse.persistence.platform.server.wls.WebLogic_10_Platform;
import org.eclipse.persistence.platform.server.wls.WebLogic_9_Platform;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.sessions.factories.XMLSessionConfigLoader;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class SessionsXMLSchemaWeblogicPlatformTest
extends AutoVerifyTestCase {
    Exception m_exceptionCaught;
    DatabaseSession m_weblogic9Session;
    DatabaseSession m_weblogic10Session;

    public SessionsXMLSchemaWeblogicPlatformTest() {
        this.setDescription("Tests loading supported and non supported weblogic platforms from the schema.");
    }

    public void reset() {
        if (this.m_weblogic9Session != null && this.m_weblogic9Session.isConnected()) {
            this.m_weblogic9Session.logout();
            SessionManager.getManager().getSessions().remove(this.m_weblogic9Session);
            this.m_weblogic9Session = null;
        }
        if (this.m_weblogic10Session != null && this.m_weblogic10Session.isConnected()) {
            this.m_weblogic10Session.logout();
            SessionManager.getManager().getSessions().remove(this.m_weblogic10Session);
            this.m_weblogic10Session = null;
        }
    }

    protected void setup() {
        this.m_exceptionCaught = null;
    }

    public void test() {
        try {
            XMLSessionConfigLoader loader = new XMLSessionConfigLoader("org/eclipse/persistence/testing/models/sessionsxml/XMLSchemaSessionWLSPlatform.xml");
            this.m_weblogic9Session = (DatabaseSession)SessionManager.getManager().getSession(loader, "Weblogic9Session", ((Object)((Object)this)).getClass().getClassLoader(), false, true);
            this.m_weblogic10Session = (DatabaseSession)SessionManager.getManager().getSession(loader, "Weblogic10Session", ((Object)((Object)this)).getClass().getClassLoader(), false, true);
        }
        catch (Exception e) {
            this.m_exceptionCaught = e;
        }
    }

    protected void verify() {
        if (this.m_exceptionCaught != null) {
            throw new TestErrorException("Loading of the session failed: " + this.m_exceptionCaught, (Throwable)this.m_exceptionCaught);
        }
        if (this.m_weblogic9Session == null) {
            throw new TestErrorException("Loaded weblogic 9 session was null");
        }
        if (!(this.m_weblogic9Session.getServerPlatform() instanceof WebLogic_9_Platform)) {
            throw new TestErrorException("The incorrect weblogic platform was set on the weblogic 9 session.");
        }
        if (this.m_weblogic10Session == null) {
            throw new TestErrorException("Loaded weblogic 10 session was null");
        }
        if (!(this.m_weblogic10Session.getServerPlatform() instanceof WebLogic_10_Platform)) {
            throw new TestErrorException("The incorrect weblogic platform was set on the weblogic 10 session.");
        }
    }
}

