/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import java.util.Vector;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class NewObjectIdentityTest
extends AutoVerifyTestCase {
    public Employee readPerson;
    public Employee origPerson;

    public NewObjectIdentityTest() {
        this.setDescription("Tests that TopLink is correctly using the original new object in the cache.");
    }

    public void setup() {
        if (this.getSession().isDistributedSession()) {
            throw new TestWarningException("Test unavailable on Remote UnitOfWork because of timing issues");
        }
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.origPerson = new Employee();
        Employee person = (Employee)uow.registerObject((Object)this.origPerson);
        person.setFirstName("Anthony");
        person.setLastName("Anthony");
        ((UnitOfWorkImpl)uow).issueSQLbeforeCompletion();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ReadAllQuery query = new ReadAllQuery(Employee.class);
                query.setSelectionCriteria(query.getExpressionBuilder().get("firstName").equal((Object)"Anthony").and(query.getExpressionBuilder().get("lastName").equal((Object)"Anthony")));
                NewObjectIdentityTest.this.readPerson = (Employee)((Vector)NewObjectIdentityTest.this.getSession().executeQuery((DatabaseQuery)query)).firstElement();
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ((UnitOfWorkImpl)uow).mergeClonesAfterCompletion();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void verify() {
        if (this.origPerson != this.readPerson) {
            throw new TestErrorException("Original New Object not placed in cache");
        }
    }

    public void reset() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.deleteObject((Object)this.readPerson);
        uow.commit();
    }
}

