/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.IsolatedClientSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TransactionalTestCase;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;

public class UOWCommitAndResumeWithPreCalcChangeSet
extends TransactionalTestCase {
    public Employee unitOfWorkWorkingCopy;
    public Employee originalObject;
    public UnitOfWork unitOfWork;
    public UnitOfWork tempUnitOfWork;

    public UOWCommitAndResumeWithPreCalcChangeSet(Employee originalObject) {
        this.originalObject = originalObject;
    }

    protected void setup() {
        super.setup();
        this.originalObject = (Employee)this.getSession().readObject(Employee.class);
        ClassDescriptor descriptor = this.getSession().getDescriptor((Object)this.originalObject);
        if (descriptor.isProtectedIsolation() && descriptor.shouldIsolateProtectedObjectsInUnitOfWork() && this.getSession() instanceof IsolatedClientSession) {
            this.originalObject = (Employee)((AbstractSession)this.getSession()).getParentIdentityMapSession(descriptor, false, true).getIdentityMapAccessor().getFromIdentityMap((Object)this.originalObject);
        }
        this.unitOfWork = this.getSession().acquireUnitOfWork();
        this.unitOfWorkWorkingCopy = (Employee)this.unitOfWork.registerObject((Object)this.originalObject);
    }

    protected void test() {
        if (this.unitOfWork.isRemoteUnitOfWork()) {
            return;
        }
        this.unitOfWorkWorkingCopy.setFirstName("Andy-Von-Trumpet");
        this.unitOfWorkWorkingCopy.addPhoneNumber(new PhoneNumber("OldCell", "555", "4545"));
        Employee newEmp = new Employee();
        newEmp.setFirstName("New");
        newEmp.setLastName("Employee");
        newEmp.setSalary(13);
        PhoneNumber phone = (PhoneNumber)this.unitOfWorkWorkingCopy.getPhoneNumbers().get(0);
        this.unitOfWorkWorkingCopy.getPhoneNumbers().remove(phone);
        this.unitOfWork.deleteObject((Object)phone);
        this.unitOfWorkWorkingCopy.addManagedEmployee(newEmp);
        if (this.compareObjects(this.originalObject, this.unitOfWorkWorkingCopy)) {
            throw new TestErrorException("The original object was changed through changing the clone.");
        }
        UnitOfWorkChangeSet changeSet = (UnitOfWorkChangeSet)this.unitOfWork.getCurrentChanges();
        this.unitOfWork.assignSequenceNumbers();
        this.unitOfWork.revertAndResume();
        ((UnitOfWorkImpl)this.unitOfWork).commitAndResumeWithPreBuiltChangeSet(changeSet);
        this.unitOfWork.release();
    }

    protected void verify() {
        if (this.unitOfWork.isRemoteUnitOfWork()) {
            return;
        }
        if (!this.originalObject.getFirstName().equals("Andy-Von-Trumpet")) {
            throw new TestErrorException("The values did not merge correctly");
        }
    }
}

