/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.EmployeePopulator;

public class UnregisteredNewObjectOptimisticLockTest
extends AutoVerifyTestCase {
    public UnregisteredNewObjectOptimisticLockTest() {
        this.setDescription("This test tests a very specific error in which a unregistered new object is inserted by a UnitOfWork specified to store new objects in identity map");
    }

    protected void setup() {
        this.getAbstractSession().beginTransaction();
    }

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    protected void test() {
        try {
            UnitOfWork uow = this.getSession().acquireUnitOfWork();
            Employee orig = (Employee)uow.readObject(Employee.class);
            uow.setShouldNewObjectsBeCached(true);
            Employee newEmp = (Employee)new EmployeePopulator().basicEmployeeExample6();
            orig.getManagedEmployees().add(newEmp);
            newEmp.setManager(orig);
            uow.commit();
            uow = this.getSession().acquireUnitOfWork();
            newEmp = (Employee)uow.readObject((Object)newEmp);
            newEmp.setFirstName("Changed Name");
            uow.commit();
        }
        catch (OptimisticLockException e) {
            throw new TestErrorException("bug 3431586 unregistered new object version number not merged into cache");
        }
    }

    protected void verify() throws Exception {
    }
}

