/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.testing.tests.validation.ExceptionTest;
import org.eclipse.persistence.testing.tests.validation.PersonMethodAccess;

public class NullPointerWhileGettingValueThruMethodAccessorTest
extends ExceptionTest {
    public NullPointerWhileGettingValueThruMethodAccessorTest() {
        this.setDescription("This tests Null Pointer While Getting Value Thru Method Accessor (TL-ERROR 70)");
    }

    protected void setup() {
        this.expectedException = DescriptorException.nullPointerWhileGettingValueThruMethodAccessor((String)"getName", (String)"Person", null);
    }

    public void test() {
        try {
            DatabaseMapping dMapping = this.descriptor().getMappingForAttributeName("p_name");
            String attributeName = dMapping.getAttributeName();
            dMapping.getAttributeAccessor().getAttributeValueFromObject((Object)attributeName);
        }
        catch (EclipseLinkException exception) {
            this.caughtException = exception;
        }
    }

    public RelationalDescriptor descriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(PersonMethodAccess.class);
        descriptor.addTableName("EMPLOYEE");
        descriptor.addPrimaryKeyFieldName("EMPLOYEE.EMP_ID");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteSoftCacheWeakIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("EMP_ID");
        descriptor.setSequenceNumberName("EMP_SEQ");
        descriptor.setAlias("EMPLOYEE");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping p_idMapping = new DirectToFieldMapping();
        p_idMapping.setAttributeName("p_id");
        p_idMapping.setFieldName("EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)p_idMapping);
        DirectToFieldMapping p_nameMapping = new DirectToFieldMapping();
        p_nameMapping.setAttributeName("p_name");
        p_nameMapping.setFieldName("EMPLOYEE.F_NAME");
        p_nameMapping.setGetMethodName("getName");
        p_nameMapping.setSetMethodName("setName");
        descriptor.addMapping((DatabaseMapping)p_nameMapping);
        return descriptor;
    }
}

