/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.collections.map;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.indirection.IndirectMap;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.collections.map.EntityDirectMapHolder;
import org.eclipse.persistence.testing.models.collections.map.EntityMapKey;

public class TestReadEntityDirectMapMapping
extends TestCase {
    protected List holders = null;
    protected int fetchJoinRelationship = 0;
    protected int oldFetchJoinValue = 0;
    protected DirectCollectionMapping mapping = null;
    protected Expression holderExp;

    public TestReadEntityDirectMapMapping() {
    }

    public TestReadEntityDirectMapMapping(int fetchJoin) {
        this();
        this.fetchJoinRelationship = fetchJoin;
        this.setName("TestReadEntityDirectMapMapping fetchJoin = " + fetchJoin);
    }

    public void setup() {
        this.mapping = (DirectCollectionMapping)this.getSession().getProject().getDescriptor(EntityDirectMapHolder.class).getMappingForAttributeName("entityToDirectMap");
        this.oldFetchJoinValue = this.mapping.getJoinFetch();
        this.mapping.setJoinFetch(this.fetchJoinRelationship);
        this.getSession().getProject().getDescriptor(EntityDirectMapHolder.class).reInitializeJoinedAttributes();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        EntityDirectMapHolder holder = new EntityDirectMapHolder();
        EntityMapKey mapKey = new EntityMapKey();
        mapKey.setId(1);
        mapKey.setData("11");
        uow.registerObject((Object)mapKey);
        holder.addEntityDirectMapItem(mapKey, new Integer(1));
        EntityMapKey mapKey2 = new EntityMapKey();
        mapKey2.setId(2);
        mapKey2.setData("22");
        uow.registerObject((Object)mapKey2);
        holder.addEntityDirectMapItem(mapKey2, new Integer(2));
        uow.registerObject((Object)holder);
        uow.commit();
        this.holderExp = new ExpressionBuilder().get("id").equal(holder.getId());
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() {
        this.holders = this.getSession().readAllObjects(EntityDirectMapHolder.class, this.holderExp);
    }

    public void verify() {
        if (this.holders == null || this.holders.size() != 1) {
            throw new TestErrorException("Incorrect number of MapHolders was read.");
        }
        EntityDirectMapHolder holder = (EntityDirectMapHolder)this.holders.get(0);
        if (!((IndirectMap)holder.getEntityToDirectMap()).getValueHolder().isInstantiated() && this.fetchJoinRelationship > 0) {
            throw new TestErrorException("Relationship was not properly joined.");
        }
        if (holder.getEntityToDirectMap().size() != 2) {
            throw new TestErrorException("Incorrect Number of Map values was read.");
        }
        EntityMapKey mapKey = new EntityMapKey();
        mapKey.setId(1);
        Integer value = (Integer)holder.getEntityToDirectMap().get(mapKey);
        if (value != 1) {
            throw new TestErrorException("Incorrect map value was read.");
        }
    }

    public void reset() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        for (EntityDirectMapHolder holder : this.holders) {
            Iterator j = holder.getEntityToDirectMap().keySet().iterator();
            while (j.hasNext()) {
                uow.deleteObject(j.next());
            }
        }
        uow.deleteAllObjects((Collection)this.holders);
        uow.commit();
        if (!this.verifyDelete(this.holders.get(0))) {
            throw new TestErrorException("Delete was unsuccessful.");
        }
        this.mapping.setJoinFetch(this.oldFetchJoinValue);
    }
}

