/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.dynamic.employee;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.dynamic.DynamicHelper;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.tests.dynamic.DynamicTestingHelper;
import org.eclipse.persistence.testing.tests.dynamic.employee.DynamicEmployeeSystem;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class MappingConfigTestSuite {
    static DatabaseSession session = null;
    static DynamicHelper dynamicHelper = null;

    @BeforeClass
    public static void setUp() {
        session = DynamicTestingHelper.createSession();
        if (8 == DynamicTestingHelper.logLevel) {
            session.dontLogMessages();
        } else {
            session.setLogLevel(DynamicTestingHelper.logLevel);
        }
        dynamicHelper = new DynamicHelper(session);
        DynamicEmployeeSystem.buildProject(dynamicHelper);
    }

    @AfterClass
    public static void tearDown() {
        session.executeNonSelectingSQL("DELETE FROM D_PROJ_EMP");
        session.executeNonSelectingSQL("DELETE FROM D_PHONE");
        session.executeNonSelectingSQL("DELETE FROM D_SALARY");
        session.executeNonSelectingSQL("DELETE FROM D_PROJECT");
        session.executeNonSelectingSQL("DELETE FROM D_EMPLOYEE");
        session.executeNonSelectingSQL("DELETE FROM D_ADDRESS");
        try {
            session.executeNonSelectingSQL("DROP TABLE D_SALARY");
            session.executeNonSelectingSQL("DROP TABLE D_PROJ_EMP");
            session.executeNonSelectingSQL("DROP TABLE D_PROJECT");
            session.executeNonSelectingSQL("DROP TABLE D_PHONE");
            session.executeNonSelectingSQL("DROP TABLE D_EMPLOYEE");
            session.executeNonSelectingSQL("DROP TABLE D_ADDRESS");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        session.logout();
        session = null;
        dynamicHelper = null;
    }

    @Test
    public void verifyEmployeeDescriptor() {
        ClassDescriptor descriptor = session.getDescriptorForAlias("Employee");
        Assert.assertNotNull((Object)descriptor);
        Assert.assertEquals((Object)"Employee", (Object)descriptor.getAlias());
        Assert.assertNull((Object)descriptor.getInheritancePolicyOrNull());
        OneToOneMapping addrMapping = (OneToOneMapping)descriptor.getMappingForAttributeName("address");
        Assert.assertNotNull((Object)addrMapping);
        Assert.assertTrue((boolean)addrMapping.isPrivateOwned());
        Assert.assertEquals((Object)session.getDescriptorForAlias("Address"), (Object)addrMapping.getReferenceDescriptor());
        OneToManyMapping phoneMapping = (OneToManyMapping)descriptor.getMappingForAttributeName("phoneNumbers");
        Assert.assertNotNull((Object)phoneMapping);
        Assert.assertTrue((boolean)phoneMapping.isPrivateOwned());
        Assert.assertEquals((Object)session.getDescriptorForAlias("PhoneNumber"), (Object)phoneMapping.getReferenceDescriptor());
        OneToOneMapping managerMapping = (OneToOneMapping)descriptor.getMappingForAttributeName("manager");
        Assert.assertNotNull((Object)managerMapping);
        Assert.assertFalse((boolean)managerMapping.isPrivateOwned());
        Assert.assertEquals((Object)descriptor, (Object)managerMapping.getReferenceDescriptor());
        OneToManyMapping managedEmployeesMapping = (OneToManyMapping)descriptor.getMappingForAttributeName("managedEmployees");
        Assert.assertNotNull((Object)managedEmployeesMapping);
        Assert.assertFalse((boolean)managedEmployeesMapping.isPrivateOwned());
        Assert.assertEquals((Object)descriptor, (Object)managedEmployeesMapping.getReferenceDescriptor());
        ManyToManyMapping projectsMapping = (ManyToManyMapping)descriptor.getMappingForAttributeName("projects");
        Assert.assertNotNull((Object)projectsMapping);
        Assert.assertFalse((boolean)projectsMapping.isPrivateOwned());
        Assert.assertEquals((Object)session.getDescriptorForAlias("Project"), (Object)projectsMapping.getReferenceDescriptor());
    }

    @Test
    public void verifyAddressDescriptor() {
        ClassDescriptor descriptor = session.getDescriptorForAlias("Address");
        Assert.assertNotNull((Object)descriptor);
        Assert.assertEquals((Object)"Address", (Object)descriptor.getAlias());
        Assert.assertNull((Object)descriptor.getInheritancePolicyOrNull());
    }

    @Test
    public void verifyPhoneNumberDescriptor() {
        ClassDescriptor descriptor = session.getDescriptorForAlias("PhoneNumber");
        Assert.assertNotNull((Object)descriptor);
        Assert.assertEquals((Object)"PhoneNumber", (Object)descriptor.getAlias());
        Assert.assertNull((Object)descriptor.getInheritancePolicyOrNull());
    }

    @Test
    public void verifyProjectDescriptor() {
        ClassDescriptor descriptor = session.getDescriptorForAlias("Project");
        Assert.assertNotNull((Object)descriptor);
        Assert.assertEquals((Object)"Project", (Object)descriptor.getAlias());
        Assert.assertNull((Object)descriptor.getInheritancePolicyOrNull());
    }
}

