/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpql;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.LargeProject;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;
import org.eclipse.persistence.testing.models.employee.domain.Project;

public class DomainObjectComparer {
    Session theSession;

    public boolean compareObjects(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        if (obj1.getClass() == Vector.class && obj2.getClass() != Vector.class) {
            return this.compareObjects(obj2, (Vector)obj1);
        }
        if (obj1.getClass() != Vector.class && obj2.getClass() == Vector.class) {
            return this.compareObjects(obj1, (Vector)obj2);
        }
        if (obj1.getClass() == Vector.class && obj2.getClass() == Vector.class) {
            return this.compareObjects((Vector)obj1, (Vector)obj2);
        }
        return ((AbstractSession)this.getSession()).compareObjects(obj1, obj2);
    }

    public boolean compareObjects(Object domainObject1, Vector aVector) {
        Enumeration enumtr = aVector.elements();
        while (enumtr.hasMoreElements()) {
            Object domainObject2 = enumtr.nextElement();
            if (!this.compareObjects(domainObject1, domainObject2)) continue;
            return true;
        }
        return false;
    }

    public boolean compareObjects(Vector objects1, Vector objects2) {
        boolean allMatched = true;
        if (objects1.size() != objects2.size()) {
            allMatched = false;
        }
        Enumeration enum1 = objects1.elements();
        while (enum1.hasMoreElements()) {
            Project proj2;
            Project proj1;
            Object obj1 = enum1.nextElement();
            if (obj1.getClass().equals(Employee.class)) {
                Employee emp1 = (Employee)obj1;
                Employee emp2 = this.findEmployeeByIdIn(emp1, objects2);
                boolean bl = allMatched = allMatched && this.compareObjects((Object)emp1, emp2);
            }
            if (obj1.getClass().equals(Project.class)) {
                proj1 = (Project)obj1;
                proj2 = this.findProjectByIdIn(proj1, objects2);
                boolean bl = allMatched = allMatched && this.compareObjects((Object)proj1, proj2);
            }
            if (obj1.getClass().equals(LargeProject.class)) {
                proj1 = (Project)obj1;
                proj2 = this.findProjectByIdIn(proj1, objects2);
                boolean bl = allMatched = allMatched && this.compareObjects((Object)proj1, proj2);
            }
            if (obj1.getClass().equals(PhoneNumber.class)) {
                PhoneNumber phone1 = (PhoneNumber)obj1;
                PhoneNumber phone2 = this.findPhoneNumberIn(phone1, objects2);
                boolean bl = allMatched = allMatched && this.compareObjects((Object)phone1, phone2);
            }
            if (!obj1.getClass().equals(String.class)) continue;
            allMatched = allMatched && objects2.indexOf(obj1) != -1;
        }
        return allMatched;
    }

    public PhoneNumber findPhoneNumberIn(PhoneNumber phone1, Vector phones) {
        Enumeration enumtr = phones.elements();
        while (enumtr.hasMoreElements()) {
            PhoneNumber pTemp = (PhoneNumber)enumtr.nextElement();
            if (!pTemp.getNumber().equals(phone1.getNumber()) || !pTemp.getAreaCode().equals(phone1.getAreaCode()) || !pTemp.getOwner().getId().equals(phone1.getOwner().getId())) continue;
            return pTemp;
        }
        return null;
    }

    public Project findProjectByIdIn(Project project, Vector projects) {
        Enumeration enumtr = projects.elements();
        while (enumtr.hasMoreElements()) {
            Project pTemp = (Project)enumtr.nextElement();
            if (!pTemp.getId().equals(project.getId())) continue;
            return pTemp;
        }
        return null;
    }

    public Employee findEmployeeByIdIn(Employee emp, Vector employees) {
        Enumeration enumtr = employees.elements();
        while (enumtr.hasMoreElements()) {
            Employee eTemp = (Employee)enumtr.nextElement();
            if (!eTemp.getId().equals(emp.getId())) continue;
            return eTemp;
        }
        return null;
    }

    public Address findAddressByIdIn(Address addr, Vector addresses) {
        Enumeration enumtr = addresses.elements();
        while (enumtr.hasMoreElements()) {
            Address aTemp = (Address)enumtr.nextElement();
            if (aTemp.getId() != addr.getId()) continue;
            return aTemp;
        }
        return null;
    }

    public Session getSession() {
        return this.theSession;
    }

    public void setSession(Session theSession) {
        this.theSession = theSession;
    }
}

