/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.optimisticlocking.cascaded;

import java.util.ArrayList;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.optimisticlocking.Cat;
import org.eclipse.persistence.testing.models.optimisticlocking.VetAppointment;

public class Cascaded12MInheritanceListOnSuperOptimisticLockingTest
extends AutoVerifyTestCase {
    private VetAppointment appt = null;
    private Cat cat = null;
    private int catVersion = 0;
    private int apptVersion = 0;

    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.getAbstractSession().beginTransaction();
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.cat = new Cat();
        this.cat.setName("Bud");
        this.appt = new VetAppointment();
        this.appt.setCost(100);
        ArrayList<VetAppointment> appts = new ArrayList<VetAppointment>();
        appts.add(this.appt);
        this.appt.getAnimal().setValue((Object)this.cat);
        uow.registerObject((Object)this.cat);
        uow.registerObject((Object)this.appt);
        uow.commit();
        this.cat = (Cat)this.getSession().refreshObject((Object)this.cat);
        this.appt = (VetAppointment)this.getSession().refreshObject((Object)this.appt);
        this.catVersion = this.cat.getVersion();
        this.apptVersion = this.appt.getVersion();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        uow = this.getSession().acquireUnitOfWork();
        this.cat = (Cat)uow.readObject((Object)this.cat);
        this.appt = this.cat.getAppointments().get(0);
        this.appt.setCost(99);
        uow.commit();
    }

    public void verify() {
        this.cat = (Cat)this.getSession().refreshObject((Object)this.cat);
        if (this.cat.getVersion() <= this.catVersion) {
            throw new TestErrorException("Version of owner was not updated through cascading.");
        }
    }

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }
}

