/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.remote;

import org.eclipse.persistence.descriptors.invalidation.CacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.TimeToLiveCacheInvalidationPolicy;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.remote.RemoteModel;

public class CacheExpiryRemoteTest
extends TestCase {
    protected static ServerSession serverSession;
    protected Employee employee = null;
    protected CacheInvalidationPolicy employeeCacheExpiryPolicy;
    protected String employeeName = null;

    public CacheExpiryRemoteTest() {
        this.setDescription("Ensure objects expire properly on a remote session.");
    }

    public void setup() {
        serverSession = ((ClientSession)RemoteModel.getServerSession()).getParent();
        this.employeeCacheExpiryPolicy = serverSession.getDescriptor(Employee.class).getCacheInvalidationPolicy();
        serverSession.getDescriptor(Employee.class).setCacheInvalidationPolicy((CacheInvalidationPolicy)new TimeToLiveCacheInvalidationPolicy(0L));
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.getAbstractSession().beginTransaction();
    }

    public void test() {
        this.employee = (Employee)this.getSession().readObject(Employee.class);
        this.employeeName = this.employee.getFirstName();
        CacheKey key = serverSession.getIdentityMapAccessorInstance().getCacheKeyForObject((Object)this.employee);
        ((Employee)key.getObject()).setFirstName(this.employee.getFirstName() + "-mutated");
    }

    public void verify() {
        this.employee = (Employee)this.getSession().readObject((Object)this.employee);
        if (this.employee.getFirstName().equals(this.employeeName + "-mutated")) {
            throw new TestErrorException("UnitOfWork update did not work correctly when expiry occurred between registration and commit.");
        }
    }

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        serverSession.getDescriptor(Employee.class).setCacheInvalidationPolicy(this.employeeCacheExpiryPolicy);
    }
}

