/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.remote;

import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.readonly.DefaultReadOnlyTestClass;

public class DefaultReadOnlyClassTest
extends TestCase {
    public DefaultReadOnlyClassTest() {
        this.setDescription("Tests whether default read only classes are available on the client of a remote session.");
    }

    public void verify() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        boolean readOnly = uow.isClassReadOnly(DefaultReadOnlyTestClass.class);
        uow.release();
        if (!readOnly) {
            throw new TestErrorException("A class was set as read-only on the server but was not read-only on the client.");
        }
    }
}

