/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.workbenchintegration;

import java.lang.reflect.Method;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.factories.ProjectClassGenerator;
import org.eclipse.persistence.sessions.factories.XMLProjectReader;
import org.eclipse.persistence.sessions.factories.XMLProjectWriter;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class WorkbenchIntegrationSystemHelper {
    public static Project buildProjectClass(Project project, String filename) {
        ProjectClassGenerator generator = new ProjectClassGenerator(project, filename, filename + ".java");
        generator.generate();
        try {
            String[] source = new String[]{filename + ".java"};
            Object[] params = new Object[]{source};
            Class<?> mainClass = Class.forName("com.sun.tools.javac.Main");
            Class[] parameterTypes = new Class[]{String[].class};
            Method method = mainClass.getMethod("compile", parameterTypes);
            int result = (Integer)method.invoke(null, params);
            if (result != 0) {
                throw new TestErrorException("Project class generation compile failed. This could either be a legitimate compile failure, or could result if you do not have the tools.jar from your JDK on the classpath.");
            }
            Class<?> projectClass = Class.forName(filename);
            return (Project)projectClass.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException("Project class generation failed.It may be possible to solve this issue by adding the tools.jar from your JDK to the classpath.", exception);
        }
    }

    public static Project buildProjectXML(Project project, String filename) {
        return WorkbenchIntegrationSystemHelper.buildProjectXML(project, filename, project.getClass().getClassLoader());
    }

    public static Project buildProjectXML(Project project, String filename, ClassLoader loader) {
        XMLProjectWriter.write((String)(filename + ".xml"), (Project)project);
        return XMLProjectReader.read((String)(filename + ".xml"), (ClassLoader)loader);
    }
}

