/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.optimisticlocking;

import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.internal.identitymaps.FullIdentityMap;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.models.optimisticlocking.Bass;
import org.eclipse.persistence.testing.models.optimisticlocking.DrumKit;
import org.eclipse.persistence.testing.models.optimisticlocking.Guitar;
import org.eclipse.persistence.testing.models.optimisticlocking.MusicalInstrument;
import org.eclipse.persistence.testing.models.optimisticlocking.Musician;
import org.eclipse.persistence.testing.models.optimisticlocking.RockBand;
import org.eclipse.persistence.testing.models.optimisticlocking.RockMusician;

public class RockBandProject
extends Project {
    public RockBandProject() {
        this.applyPROJECT();
        this.applyLOGIN();
        this.buildBassDescriptor();
        this.buildDrumKitDescriptor();
        this.buildGuitarDescriptor();
        this.buildMusicalInstrumentDescriptor();
        this.buildMusicianDescriptor();
        this.buildRockBandDescriptor();
        this.buildRockMusicianDescriptor();
    }

    protected void applyLOGIN() {
    }

    protected void applyPROJECT() {
        this.setName("RockBand");
    }

    protected void buildBassDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Bass.class);
        descriptor.getInheritancePolicy().setParentClass(Guitar.class);
        descriptor.setIdentityMapClass(FullIdentityMap.class);
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.getInheritancePolicy().setShouldReadSubclasses(true);
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildDrumKitDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(DrumKit.class);
        descriptor.getInheritancePolicy().setParentClass(MusicalInstrument.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("DRUMKIT");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("DRUMKIT.ID");
        descriptor.setIdentityMapClass(FullIdentityMap.class);
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.getInheritancePolicy().setShouldReadSubclasses(true);
        Vector<String> v = new Vector<String>();
        v.addElement("MUSICALINSTRUMENT.L_FIELD");
        v.addElement("DRUMKIT.KIT_SIZE");
        descriptor.useSelectedFieldsLocking(v);
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("kitSize");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("DRUMKIT.KIT_SIZE");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildGuitarDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Guitar.class);
        descriptor.getInheritancePolicy().setParentClass(MusicalInstrument.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("GUITAR");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("GUITAR.ID");
        descriptor.setIdentityMapClass(FullIdentityMap.class);
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.getInheritancePolicy().setShouldReadSubclasses(true);
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("isAcoustic");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("GUITAR.IS_ACOUSTIC");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("numberOfStrings");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("GUITAR.NUMBER_OF_STRINGS");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildMusicalInstrumentDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(MusicalInstrument.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("MUSICALINSTRUMENT");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("MUSICALINSTRUMENT.ID");
        descriptor.setIdentityMapClass(FullIdentityMap.class);
        descriptor.setSequenceNumberName("INS_EQ");
        descriptor.setSequenceNumberFieldName("ID");
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.getInheritancePolicy().setShouldReadSubclasses(true);
        descriptor.getInheritancePolicy().setClassIndicatorFieldName("SUBCLASS");
        descriptor.getInheritancePolicy().setShouldUseClassNameAsIndicator(true);
        Vector<String> v = new Vector<String>();
        v.addElement("MUSICALINSTRUMENT.L_FIELD");
        descriptor.useSelectedFieldsLocking(v);
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("colour");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("MUSICALINSTRUMENT.COLOUR");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("id");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("MUSICALINSTRUMENT.ID");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        DirectToFieldMapping directtofieldmapping2 = new DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("make");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setFieldName("MUSICALINSTRUMENT.MAKE");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping2);
        this.addDescriptor((ClassDescriptor)descriptor);
        DirectToFieldMapping directtofieldmapping3 = new DirectToFieldMapping();
        directtofieldmapping3.setAttributeName("lockField");
        directtofieldmapping3.setIsReadOnly(false);
        directtofieldmapping3.setFieldName("MUSICALINSTRUMENT.L_FIELD");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping3);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildMusicianDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Musician.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("MUSICIAN");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("MUSICIAN.ID");
        descriptor.setIdentityMapClass(FullIdentityMap.class);
        descriptor.setSequenceNumberName("MUSIC_SEQ");
        descriptor.setSequenceNumberFieldName("ID");
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.getInheritancePolicy().setShouldReadSubclasses(true);
        descriptor.getInheritancePolicy().setClassIndicatorFieldName("SUBCLASS");
        descriptor.getInheritancePolicy().setShouldUseClassNameAsIndicator(true);
        descriptor.useAllFieldsLocking();
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("id");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("MUSICIAN.ID");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("legalName");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("MUSICIAN.LEGAL_NAME");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        OneToOneMapping onetoonemapping = new OneToOneMapping();
        onetoonemapping.setAttributeName("mainInstrument");
        onetoonemapping.setIsReadOnly(false);
        onetoonemapping.setUsesIndirection(false);
        onetoonemapping.setReferenceClass(MusicalInstrument.class);
        onetoonemapping.setIsPrivateOwned(false);
        onetoonemapping.addForeignKeyFieldName("MUSICIAN.MAIN_INSTRUMENT", "MUSICALINSTRUMENT.ID");
        descriptor.addMapping((DatabaseMapping)onetoonemapping);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildRockBandDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(RockBand.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("ROCKBAND");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("ROCKBAND.ID");
        descriptor.setIdentityMapClass(FullIdentityMap.class);
        descriptor.setSequenceNumberName("BAND_SEQ");
        descriptor.setSequenceNumberFieldName("ID");
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.useChangedFieldsLocking();
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("id");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("ROCKBAND.ID");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("name");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("ROCKBAND.NAME");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        OneToManyMapping onetomanymapping = new OneToManyMapping();
        onetomanymapping.setAttributeName("bandMembers");
        onetomanymapping.setIsReadOnly(false);
        onetomanymapping.setUsesIndirection(true);
        onetomanymapping.setReferenceClass(RockMusician.class);
        onetomanymapping.setIsPrivateOwned(false);
        onetomanymapping.addTargetForeignKeyFieldName("ROCKMUSICIAN.BAND", "ROCKBAND.ID");
        descriptor.addMapping((DatabaseMapping)onetomanymapping);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildRockMusicianDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(RockMusician.class);
        descriptor.getInheritancePolicy().setParentClass(Musician.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("ROCKMUSICIAN");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("ROCKMUSICIAN.ID");
        descriptor.setIdentityMapClass(FullIdentityMap.class);
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.getInheritancePolicy().setShouldReadSubclasses(true);
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("stageName");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("ROCKMUSICIAN.STAGE_NAME");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        OneToOneMapping onetoonemapping = new OneToOneMapping();
        onetoonemapping.setAttributeName("band");
        onetoonemapping.setIsReadOnly(false);
        onetoonemapping.setUsesIndirection(true);
        onetoonemapping.setReferenceClass(RockBand.class);
        onetoonemapping.setIsPrivateOwned(false);
        onetoonemapping.addForeignKeyFieldName("ROCKMUSICIAN.BAND_ID", "ROCKBAND.ID");
        descriptor.addMapping((DatabaseMapping)onetoonemapping);
        this.addDescriptor((ClassDescriptor)descriptor);
    }
}

