/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.aggregate;

import java.util.Collection;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.aggregate.Bicycle;
import org.eclipse.persistence.testing.models.aggregate.Transport;

public class AggregateInheritanceInitAggregateTestCase
extends AutoVerifyTestCase {
    protected Transport workingCopy;

    public void reset() {
        DatabaseSession session = (DatabaseSession)this.getSession();
        UnitOfWork uow = session.acquireUnitOfWork();
        ExpressionBuilder transport = new ExpressionBuilder();
        Expression expression = transport.get("id").equal(this.workingCopy.getId());
        uow.deleteAllObjects((Collection)uow.readAllObjects(Transport.class, expression));
        uow.commit();
    }

    public void setup() {
    }

    public void test() {
        DatabaseSession session = (DatabaseSession)this.getSession();
        UnitOfWork uow = session.acquireUnitOfWork();
        Transport transport = Transport.example1();
        this.workingCopy = (Transport)uow.registerObject((Object)transport);
        this.workingCopy.setVehicle(Bicycle.example1());
        uow.commit();
    }

    public void verify() {
        ExpressionBuilder transport;
        Expression expression;
        DatabaseSession session = (DatabaseSession)this.getSession();
        Transport transportFromTL = (Transport)session.readObject(Transport.class, expression = (transport = new ExpressionBuilder()).get("id").equal(this.workingCopy.getId()));
        if (!this.compareObjects(transportFromTL, this.workingCopy)) {
            throw new TestErrorException("The Aggregate was changed by type, but the cache was not updated.");
        }
    }
}

