/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.dynamic.projectxml;

import java.io.IOException;
import java.math.BigInteger;
import java.sql.Date;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicHelper;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.dynamic.DynamicTypeBuilder;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.tests.dynamic.DynamicTestingHelper;
import org.eclipse.persistence.tools.schemaframework.DynamicSchemaManager;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SimpleMapProject {
    public static final String PACKAGE_PREFIX = SimpleMapProject.class.getPackage().getName();
    static final String PROJECT_XML = PACKAGE_PREFIX.replace('.', '/') + "/simple-map-project.xml";
    static DatabaseSession session = null;
    static DynamicHelper dynamicHelper = null;

    @BeforeClass
    public static void setUp() {
        DynamicClassLoader dcl = new DynamicClassLoader(SimpleMapProject.class.getClassLoader());
        Project project = null;
        try {
            project = DynamicTypeBuilder.loadDynamicProject((String)PROJECT_XML, (DatabaseLogin)DynamicTestingHelper.createLogin(), (DynamicClassLoader)dcl);
        }
        catch (IOException e) {
            Assert.fail((String)"cannot find simple-map-project.xml");
        }
        session = project.createDatabaseSession();
        if (8 == DynamicTestingHelper.logLevel) {
            session.dontLogMessages();
        } else {
            session.setLogLevel(DynamicTestingHelper.logLevel);
        }
        dynamicHelper = new DynamicHelper(session);
        session.login();
        new DynamicSchemaManager(session).createTables(new DynamicType[0]);
    }

    @AfterClass
    public static void tearDown() {
        session.executeNonSelectingSQL("DROP TABLE SIMPLETABLE");
        session.logout();
        session = null;
        dynamicHelper = null;
    }

    @After
    public void clearTable() {
        session.executeNonSelectingSQL("DELETE FROM SIMPLETABLE");
    }

    @Test
    public void verifyDescriptor() throws Exception {
        ClassDescriptor descriptor = session.getClassDescriptorForAlias("simpletableType");
        Assert.assertNotNull((Object)descriptor);
        Assert.assertEquals((Object)"simpletable.Simpletable", (Object)descriptor.getJavaClassName());
        Assert.assertEquals((long)3L, (long)descriptor.getMappings().size());
        DatabaseMapping idMapping = descriptor.getMappingForAttributeName("id");
        Assert.assertNotNull((Object)idMapping);
        Assert.assertTrue((boolean)idMapping.isDirectToFieldMapping());
        Assert.assertEquals(BigInteger.class, (Object)idMapping.getAttributeClassification());
        DatabaseMapping nameMapping = descriptor.getMappingForAttributeName("name");
        Assert.assertNotNull((Object)nameMapping);
        Assert.assertTrue((boolean)nameMapping.isDirectToFieldMapping());
        Assert.assertEquals(String.class, (Object)nameMapping.getAttributeClassification());
        DatabaseMapping sinceMapping = descriptor.getMappingForAttributeName("since");
        Assert.assertNotNull((Object)sinceMapping);
        Assert.assertTrue((boolean)sinceMapping.isDirectToFieldMapping());
        Assert.assertEquals(Date.class, (Object)sinceMapping.getAttributeClassification());
    }

    @Test
    public void createInstance() {
        DynamicType type = dynamicHelper.getType("simpletableType");
        ReportQuery countQuery = dynamicHelper.newReportQuery("simpletableType", new ExpressionBuilder());
        countQuery.addCount();
        countQuery.setShouldReturnSingleValue(true);
        Assert.assertEquals((long)0L, (long)((Number)session.executeQuery((DatabaseQuery)countQuery)).intValue());
        DynamicEntity entity = type.newDynamicEntity();
        entity.set("id", (Object)new BigInteger("1"));
        entity.set("name", (Object)"Example");
        entity.set("since", (Object)new Date(100, 6, 6));
        UnitOfWork uow = session.acquireUnitOfWork();
        uow.registerNewObject((Object)entity);
        uow.commit();
        Assert.assertEquals((long)1L, (long)((Number)session.executeQuery((DatabaseQuery)countQuery)).intValue());
        session.release();
    }

    @Test
    public void readAll() {
        this.createInstance();
        DynamicType type = dynamicHelper.getType("simpletableType");
        Vector allObjects = session.readAllObjects(type.getJavaClass());
        Assert.assertEquals((long)1L, (long)allObjects.size());
    }

    @Test
    public void readById() {
        this.createInstance();
        ReadObjectQuery query = dynamicHelper.newReadObjectQuery("simpletableType");
        query.setSelectionCriteria(query.getExpressionBuilder().get("id").equal(1));
        DynamicEntity entity = (DynamicEntity)session.executeQuery((DatabaseQuery)query);
        Assert.assertNotNull((Object)entity);
    }

    @Test
    public void delete() {
        this.createInstance();
        ReadObjectQuery query = dynamicHelper.newReadObjectQuery("simpletableType");
        query.setSelectionCriteria(query.getExpressionBuilder().get("id").equal(1));
        UnitOfWork uow = session.acquireUnitOfWork();
        DynamicEntity entity = (DynamicEntity)uow.executeQuery((DatabaseQuery)query);
        Assert.assertNotNull((Object)entity);
        uow.deleteObject((Object)entity);
        uow.commit();
        ReportQuery countQuery = dynamicHelper.newReportQuery("simpletableType", new ExpressionBuilder());
        countQuery.addCount();
        countQuery.setShouldReturnSingleValue(true);
        Assert.assertEquals((long)0L, (long)((Number)session.executeQuery((DatabaseQuery)countQuery)).intValue());
    }
}

