/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.expressions;

import java.sql.SQLException;
import java.util.Vector;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.ReadAllTest;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class ReadAllExpressionTest
extends ReadAllTest {
    protected Expression expression;
    protected boolean testBatchAttributesOnEmployee;
    protected boolean supportedInMemory = true;
    protected Vector supportedPlatforms;
    protected Vector unsupportedPlatforms;
    protected Object hardReferenceToInMemoryObjects;

    public ReadAllExpressionTest(Class referenceClass, int originalObjectsSize) {
        super(referenceClass, originalObjectsSize);
    }

    public Expression getExpression() {
        if (this.expression == null && this.getQuery() != null) {
            this.expression = this.getQuery().getSelectionCriteria();
        }
        return this.expression;
    }

    public ReadAllQuery getQuery(boolean initializeNow) {
        if (initializeNow && this.getQuery() == null) {
            this.setQuery(new ReadAllQuery());
            this.getQuery().setReferenceClass(this.getReferenceClass());
            this.getQuery().setSelectionCriteria(this.getExpression());
        }
        return this.getQuery();
    }

    public boolean isPlatformSpecific() {
        return this.supportedPlatforms != null || this.unsupportedPlatforms != null;
    }

    public boolean isPlatformSupported(DatabasePlatform platform) {
        boolean supported = false;
        boolean notSupported = false;
        if (this.unsupportedPlatforms == null && this.supportedPlatforms == null) {
            return true;
        }
        if (this.supportedPlatforms != null) {
            for (Class platformClass : this.supportedPlatforms) {
                if (!platformClass.isInstance(platform)) continue;
                supported = true;
            }
        } else {
            supported = true;
        }
        if (this.unsupportedPlatforms != null) {
            for (Class platformClass : this.unsupportedPlatforms) {
                if (!platformClass.isInstance(platform)) continue;
                notSupported = true;
            }
        }
        return supported && !notSupported;
    }

    public void setExpression(Expression theExpression) {
        this.expression = theExpression;
    }

    public void setSupportedInMemory(boolean supportedInMemory) {
        this.supportedInMemory = supportedInMemory;
    }

    protected void setup() {
        if (!this.isPlatformSupported((DatabasePlatform)this.getSession().getLogin().getPlatform())) {
            throw new TestWarningException("This expression is not supported on this platform.");
        }
        this.getQuery(true).setIsPrepared(false);
        try {
            if (this.getName().equals("MultiPlatformTest") && this.getSession().getLogin().getPlatform().isOracle() && this.getAbstractSession().getAccessor().getConnection().getMetaData().getDriverVersion().indexOf("8.1.7") != -1) {
                throw new TestWarningException("CASE not supported until Oracle 9i.");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (this.shouldTestBatchAttributesOnEmployee()) {
            this.setupBatchAttributes();
        }
        if (this.getQuery().shouldCheckCacheOnly()) {
            this.setHardReferenceToInMemoryObjects(this.getSession().readAllObjects(this.getReferenceClass()));
        }
    }

    public void reset() throws Exception {
        super.reset();
        this.freeHardReferenceToInMemoryObjects();
    }

    protected void test() {
        if (this.shouldTestBatchAttributesOnEmployee()) {
            super.test();
            this.testBatchAttributes();
        } else {
            try {
                super.test();
            }
            catch (QueryException exception) {
                if (!this.supportedInMemory && exception.getErrorCode() == 6074) {
                    throw new TestWarningException("This test is not supported In-Memory");
                }
                throw new TestErrorException("Fatal query exception occurred.", (Throwable)exception);
            }
        }
    }

    public void addSupportedPlatform(Class platform) {
        if (this.supportedPlatforms == null) {
            this.supportedPlatforms = new Vector();
        }
        this.supportedPlatforms.addElement(platform);
    }

    public void addUnsupportedPlatform(Class platform) {
        if (this.unsupportedPlatforms == null) {
            this.unsupportedPlatforms = new Vector();
        }
        this.unsupportedPlatforms.addElement(platform);
    }

    public void dontTestBatchAttributesOnEmployee() {
        this.testBatchAttributesOnEmployee = false;
    }

    public boolean shouldTestBatchAttributesOnEmployee() {
        return this.testBatchAttributesOnEmployee;
    }

    public void testBatchAttributesOnEmployee() {
        this.testBatchAttributesOnEmployee = true;
    }

    protected void freeHardReferenceToInMemoryObjects() {
        this.hardReferenceToInMemoryObjects = null;
    }

    protected void setHardReferenceToInMemoryObjects(Object hardReference) {
        this.hardReferenceToInMemoryObjects = hardReference;
    }

    protected void setupBatchAttributes() {
        this.getQuery().addBatchReadAttribute("phoneNumbers");
        this.getQuery().addBatchReadAttribute("address");
        this.getQuery().addBatchReadAttribute("responsibilitiesList");
        this.getQuery().addBatchReadAttribute("projects");
    }

    protected void testBatchAttributes() {
        Vector result = (Vector)this.objectsFromDatabase;
        Vector phoneNumbers = ((Employee)result.elementAt(0)).getPhoneNumbers();
        ((Employee)result.elementAt(0)).getResponsibilitiesList().size();
        ((Employee)result.elementAt(0)).getProjects().size();
        if (phoneNumbers == null || phoneNumbers.size() == 0) {
            throw new TestErrorException("The original query was corrupted when made part of a batch query.");
        }
        if (((Employee)result.elementAt(0)).getAddress() == null) {
            throw new TestErrorException("The original query was corrupted when made part of a batch query.");
        }
    }
}

