/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.feature;

import junit.framework.Test;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.models.aggregate.AggregateSystem;
import org.eclipse.persistence.testing.models.bigbad.BigBadSystem;
import org.eclipse.persistence.testing.models.collections.CollectionsSystem;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeSystem;
import org.eclipse.persistence.testing.models.events.EventHookSystem;
import org.eclipse.persistence.testing.models.inheritance.InheritanceSystem;
import org.eclipse.persistence.testing.models.insurance.InsuranceSystem;
import org.eclipse.persistence.testing.models.legacy.LegacySystem;
import org.eclipse.persistence.testing.models.mapping.MappingSystem;
import org.eclipse.persistence.testing.models.multipletable.ProjectSystem;
import org.eclipse.persistence.testing.models.ownership.OwnershipSystem;
import org.eclipse.persistence.testing.models.sequencing.SequenceTestSystem;
import org.eclipse.persistence.testing.models.vehicle.VehicleSystem;
import org.eclipse.persistence.testing.tests.events.EventHookTestSuite;
import org.eclipse.persistence.testing.tests.expressions.ExpressionInMemoryTestSuite;
import org.eclipse.persistence.testing.tests.expressions.ExpressionOperatorUnitTestSuite;
import org.eclipse.persistence.testing.tests.expressions.ExpressionOuterJoinTestSuite;
import org.eclipse.persistence.testing.tests.expressions.ExpressionSubSelectTestSuite;
import org.eclipse.persistence.testing.tests.expressions.ExpressionTestSuite;
import org.eclipse.persistence.testing.tests.expressions.ExpressionUnitTestSuite;
import org.eclipse.persistence.testing.tests.feature.CannotOverrideConnectedSequenceTest;
import org.eclipse.persistence.testing.tests.feature.ContainerCloningTest;
import org.eclipse.persistence.testing.tests.feature.ContainerIndirectionPolicySerializationTest;
import org.eclipse.persistence.testing.tests.feature.CustomSequenceTest;
import org.eclipse.persistence.testing.tests.feature.CustomSequencingPolicyTest;
import org.eclipse.persistence.testing.tests.feature.DatabaseLoginCodeCoverageTest;
import org.eclipse.persistence.testing.tests.feature.ExceptionHandlerLoginIntegrityTest;
import org.eclipse.persistence.testing.tests.feature.ExceptionHandlerTest1;
import org.eclipse.persistence.testing.tests.feature.ExceptionHandlerTest2;
import org.eclipse.persistence.testing.tests.feature.FieldedMessageLoggingTest;
import org.eclipse.persistence.testing.tests.feature.FieldedMessageLoggingTraceLocalizationTest;
import org.eclipse.persistence.testing.tests.feature.GermanUmlautsWriteTest;
import org.eclipse.persistence.testing.tests.feature.GetClassDescriptorForAliasTest;
import org.eclipse.persistence.testing.tests.feature.HelperSystemPropertyTest;
import org.eclipse.persistence.testing.tests.feature.InitializeDescriptorsBeforeLoginTest;
import org.eclipse.persistence.testing.tests.feature.InstantiationPolicyTest;
import org.eclipse.persistence.testing.tests.feature.IntegrityCheckerLazyCreationTest;
import org.eclipse.persistence.testing.tests.feature.IntegrityCheckerTest;
import org.eclipse.persistence.testing.tests.feature.JNDIConnectionTest;
import org.eclipse.persistence.testing.tests.feature.MessageLoggingEfficiencyTest;
import org.eclipse.persistence.testing.tests.feature.NoDefaultNullValueTest;
import org.eclipse.persistence.testing.tests.feature.NullPasswordLoginTest;
import org.eclipse.persistence.testing.tests.feature.NullValueTest;
import org.eclipse.persistence.testing.tests.feature.ObjectCopyingTest;
import org.eclipse.persistence.testing.tests.feature.OptimisticLockingChangedValueTest;
import org.eclipse.persistence.testing.tests.feature.OptimisticLockingChangedValueUpdateTest;
import org.eclipse.persistence.testing.tests.feature.OptimisticLockingDeleteRowTest;
import org.eclipse.persistence.testing.tests.feature.OptimisticLockingDeleteValueUpdateTest;
import org.eclipse.persistence.testing.tests.feature.OptomizeValueHolderTest;
import org.eclipse.persistence.testing.tests.feature.ReconnectFlushStatementCacheTest;
import org.eclipse.persistence.testing.tests.feature.SequenceFieldRemovalForAcquireValueAfterInsertTest;
import org.eclipse.persistence.testing.tests.feature.SequenceStringExistingPKTest;
import org.eclipse.persistence.testing.tests.feature.SequenceStringPKInsertTest;
import org.eclipse.persistence.testing.tests.feature.SequencingConcurrencyTest;
import org.eclipse.persistence.testing.tests.feature.SequencingRollbackTest;
import org.eclipse.persistence.testing.tests.feature.SequencingTableQualifierTest;
import org.eclipse.persistence.testing.tests.feature.SessionIsConnectedFlagTest;
import org.eclipse.persistence.testing.tests.feature.ShouldCheckDatabaseTest;
import org.eclipse.persistence.testing.tests.feature.ShouldNotCheckDatabaseTest;
import org.eclipse.persistence.testing.tests.feature.ShouldNotThroughIntegrityCheckerTest;
import org.eclipse.persistence.testing.tests.feature.ShouldThroughIntegrityCheckerTest;
import org.eclipse.persistence.testing.tests.feature.TransactionIsolationTest;
import org.eclipse.persistence.testing.tests.identitymaps.IdentityMapTestSuite;
import org.eclipse.persistence.testing.tests.queries.IdentitySystem;
import org.eclipse.persistence.testing.tests.queries.QueryFrameworkTestSuite;
import org.eclipse.persistence.testing.tests.queries.inmemory.CacheHitAndInMemoryTestSuite;
import org.eclipse.persistence.testing.tests.queries.optimization.QueryOptimizationTestSuite;
import org.eclipse.persistence.testing.tests.queries.options.QueryOptionSystem;
import org.eclipse.persistence.testing.tests.queries.options.QueryOptionTestSuite;
import org.eclipse.persistence.testing.tests.queries.report.ReportQuerySystem;
import org.eclipse.persistence.testing.tests.queries.report.ReportQueryTestSuite;
import org.eclipse.persistence.testing.tests.queries.repreparation.QueryRepreparationTestSuite;
import org.eclipse.persistence.testing.tests.sessioncache.SessionCacheTestSuite;
import org.eclipse.persistence.testing.tests.transactions.ReadingThroughWriteConnectionInTransactionTest;
import org.eclipse.persistence.testing.tests.transactions.TransactionTestSuite;
import org.eclipse.persistence.testing.tests.writing.CommitOrderTest;

public class FeatureTestModel
extends TestModel {
    public static junit.framework.TestSuite suite() {
        return new FeatureTestModel();
    }

    public FeatureTestModel() {
        this.setDescription("This model tests selected TopLink features using the employee demo.");
    }

    public FeatureTestModel(boolean isSRG) {
        this();
        this.isSRG = isSRG;
    }

    public void addRequiredSystems() {
        this.addRequiredSystem(new EmployeeSystem());
        this.addRequiredSystem(new AggregateSystem());
        this.addRequiredSystem(new InheritanceSystem());
        this.addRequiredSystem(new InsuranceSystem());
        this.addRequiredSystem(new OwnershipSystem());
        this.addRequiredSystem(new LegacySystem());
        this.addRequiredSystem(new EventHookSystem());
        this.addRequiredSystem(new ProjectSystem());
        this.addRequiredSystem(new IdentitySystem());
        this.addRequiredSystem(new CollectionsSystem());
        this.addRequiredSystem(new MappingSystem());
        this.addRequiredSystem(new SequenceTestSystem());
        this.addRequiredSystem(new ReportQuerySystem());
        this.addRequiredSystem(new QueryOptionSystem());
        this.addRequiredSystem(new BigBadSystem());
        this.addRequiredSystem(new VehicleSystem());
        if (this.getSession().getPlatform().isPostgreSQL()) {
            this.getSession().getPlatform().setShouldForceFieldNamesToUpperCase(true);
        }
    }

    public void addTests() {
        this.addTest((Test)new IdentityMapTestSuite());
        this.addTest((Test)new ExpressionTestSuite());
        this.addTest((Test)new ExpressionInMemoryTestSuite());
        this.addTest((Test)new ExpressionSubSelectTestSuite());
        this.addTest((Test)new ExpressionOperatorUnitTestSuite());
        this.addTest((Test)new ExpressionOuterJoinTestSuite());
        this.addTest((Test)new ExpressionUnitTestSuite());
        this.addTest((Test)new QueryFrameworkTestSuite());
        this.addTest((Test)new CacheHitAndInMemoryTestSuite());
        this.addTest((Test)new EventHookTestSuite());
        this.addTest((Test)FeatureTestModel.getOptimisticLockingTestSuite());
        this.addTest((Test)new QueryOptimizationTestSuite());
        this.addTest((Test)new ReportQueryTestSuite());
        this.addTest((Test)new TransactionTestSuite());
        this.addTest((Test)FeatureTestModel.getReadingThroughWriteConnectionSuite());
        this.addTest((Test)FeatureTestModel.getIntegrityCheckerTestSuite());
        this.addTest((Test)FeatureTestModel.getExceptionHandlerTestSuite());
        this.addTest((Test)FeatureTestModel.getMessageLoggingTestSuite());
        this.addTest((Test)FeatureTestModel.getFieldedMessageLoggingTestSuite());
        this.addTest((Test)FeatureTestModel.getNullValueTestSuite());
        this.addTest((Test)FeatureTestModel.getMiscTestSuite());
        if (!this.getExecutor().isServer) {
            this.addTest((Test)FeatureTestModel.getJNDIConnectionTestSuite());
        }
        this.addTest((Test)FeatureTestModel.getCustomSequenceTestSuite());
        this.addTest((Test)FeatureTestModel.getSequenceTestSuite());
        this.addTest((Test)FeatureTestModel.getCopyingTestSuite());
        this.addTest((Test)new QueryOptionTestSuite());
        this.addTest((Test)new QueryRepreparationTestSuite());
        this.addTest((Test)FeatureTestModel.getDatabaseLoginCodeCoverageTestSuite());
        this.addTest((Test)FeatureTestModel.getInstantiationPoicyTestSuite());
        this.addTest((Test)new SessionCacheTestSuite());
        this.addTest((Test)FeatureTestModel.getSessionAPITestSuite());
        this.addTest((Test)new CommitOrderTest());
    }

    public void addSRGTests() {
        this.addTest((Test)new ExpressionTestSuite(true));
        this.addTest((Test)new QueryFrameworkTestSuite(true));
        this.addTest((Test)new TransactionTestSuite(true));
        this.addTest((Test)new EventHookTestSuite(true));
    }

    public static TestSuite getReadingThroughWriteConnectionSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("ReadingThroughWriteConnectionSuite");
        suite.setDescription("This suite tests reading through write connection when in transaction and using a client/server.");
        suite.addTests(ReadingThroughWriteConnectionInTransactionTest.buildTests());
        return suite;
    }

    public static TestSuite getDatabaseLoginCodeCoverageTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("DatabaseLoginCodeCoverageTestSuite");
        suite.setDescription("This tests code coverage for DatabaseLogin.");
        suite.addTest((Test)new DatabaseLoginCodeCoverageTest());
        return suite;
    }

    public static TestSuite getCopyingTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("CopyingTestSuite");
        suite.setDescription("This tests object copying.");
        suite.addTest((Test)new ObjectCopyingTest());
        suite.addTest((Test)new ContainerCloningTest());
        return suite;
    }

    public static TestSuite getCustomSequenceTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("CustomSequenceTestSuite");
        suite.setDescription("This tests custom sequencing.");
        suite.addTest((Test)new CustomSequenceTest());
        return suite;
    }

    public static TestSuite getExceptionHandlerTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("ExceptionHandler");
        suite.setDescription("This Suite tests the functionality of ExceptionHandler.");
        suite.addTest((Test)new ExceptionHandlerTest1());
        suite.addTest((Test)new ExceptionHandlerTest2());
        suite.addTest((Test)new ExceptionHandlerLoginIntegrityTest());
        return suite;
    }

    public static TestSuite getMessageLoggingTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("Message Logging");
        suite.setDescription("This Suite tests the functionality of Logging messages.");
        suite.addTest((Test)new MessageLoggingEfficiencyTest());
        return suite;
    }

    public static TestSuite getFieldedMessageLoggingTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("Fielded Message Logging");
        suite.setDescription("This Suite tests the functionality of Logging messages containing formatting strings.");
        suite.addTest((Test)new FieldedMessageLoggingTest());
        suite.addTest((Test)new FieldedMessageLoggingTraceLocalizationTest());
        return suite;
    }

    public static TestSuite getIntegrityCheckerTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("Integrity Checker");
        suite.setDescription("This Suite tests the functionality of Integrity Checker.");
        suite.addTest((Test)new IntegrityCheckerTest());
        suite.addTest((Test)new IntegrityCheckerLazyCreationTest());
        suite.addTest((Test)new ShouldThroughIntegrityCheckerTest());
        suite.addTest((Test)new ShouldNotThroughIntegrityCheckerTest());
        suite.addTest((Test)new ShouldCheckDatabaseTest());
        suite.addTest((Test)new ShouldNotCheckDatabaseTest());
        return suite;
    }

    public static TestSuite getJNDIConnectionTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("JNDIConnectionTestSuite");
        suite.setDescription("Test connecting to a database with a JNDI-supplied DataSource");
        suite.addTest((Test)new JNDIConnectionTest());
        return suite;
    }

    public static TestSuite getMiscTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("MiscellaneousTests");
        suite.setDescription("Tests that don't fit anywhere else.  Okay, sue me.");
        suite.addTest((Test)new OptomizeValueHolderTest());
        suite.addTest((Test)new NullPasswordLoginTest());
        suite.addTest((Test)new HelperSystemPropertyTest());
        suite.addTest((Test)new GermanUmlautsWriteTest());
        suite.addTest((Test)new ReconnectFlushStatementCacheTest());
        suite.addTest((Test)new TransactionIsolationTest());
        suite.addTest((Test)new SessionIsConnectedFlagTest());
        suite.addTest((Test)new ContainerIndirectionPolicySerializationTest());
        return suite;
    }

    public static TestSuite getNullValueTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("NullValueTestSuite");
        suite.setDescription("Test default null value settings");
        suite.addTest((Test)new NullValueTest());
        suite.addTest((Test)new NoDefaultNullValueTest());
        return suite;
    }

    public static TestSuite getOptimisticLockingTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("OptimisticLockingTestSuite");
        suite.setDescription("This suite tests the functionality of the optimistic locking feature.");
        suite.addTest((Test)new OptimisticLockingDeleteRowTest());
        suite.addTest((Test)new OptimisticLockingChangedValueTest());
        suite.addTest((Test)new OptimisticLockingChangedValueUpdateTest());
        suite.addTest((Test)new OptimisticLockingDeleteValueUpdateTest());
        return suite;
    }

    public static TestSuite getSequenceTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("SequenceTestSuite");
        suite.setDescription("This tests both custom and regular sequencing.");
        suite.addTest((Test)new CustomSequenceTest());
        suite.addTest((Test)new SequencingConcurrencyTest(7, 100, false, false));
        suite.addTest((Test)new SequencingConcurrencyTest(7, 100, false, false, 2));
        suite.addTest((Test)new SequencingConcurrencyTest(7, 100, false, true));
        suite.addTest((Test)new SequencingConcurrencyTest(7, 100, true, false));
        suite.addTest((Test)new SequencingConcurrencyTest(7, 100, true, false, 2));
        suite.addTest((Test)new SequencingConcurrencyTest(7, 100, true, true));
        suite.addTest((Test)new SequencingRollbackTest(true));
        suite.addTest((Test)new SequencingRollbackTest(false));
        suite.addTest((Test)new SequenceStringPKInsertTest());
        suite.addTest((Test)new SequenceStringExistingPKTest());
        suite.addTest((Test)new CustomSequencingPolicyTest());
        suite.addTest((Test)new InitializeDescriptorsBeforeLoginTest());
        suite.addTest((Test)new SequencingTableQualifierTest(1));
        suite.addTest((Test)new SequencingTableQualifierTest(2));
        suite.addTest((Test)new SequenceFieldRemovalForAcquireValueAfterInsertTest());
        suite.addTest((Test)new CannotOverrideConnectedSequenceTest());
        return suite;
    }

    public static TestSuite getInstantiationPoicyTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("Instantiation Policy Test Suite");
        suite.setDescription("Test instantiation policy feature.");
        suite.addTest((Test)new InstantiationPolicyTest());
        return suite;
    }

    public static TestSuite getSessionAPITestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("Session API Test Suite");
        suite.setDescription("Test Session API.");
        suite.addTest((Test)new GetClassDescriptorForAliasTest());
        return suite;
    }
}

