/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.helper;

import java.sql.Timestamp;
import java.util.Date;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class TimestampFromDateTest
extends AutoVerifyTestCase {
    Date currentTime;
    Timestamp optimizedTime;
    boolean optimizedDatesState;

    public static void main(String[] args) {
        TimestampFromDateTest test = new TimestampFromDateTest();
        test.setup();
        test.test();
        test.verify();
        test.reset();
    }

    public TimestampFromDateTest() {
        this.setDescription("Test of Helper.timestampFromDate(java.util.Date dateObject)");
    }

    public void setup() {
        this.currentTime = Helper.utilDateFromLong((Long)new Long(System.currentTimeMillis()));
        this.optimizedDatesState = Helper.shouldOptimizeDates();
    }

    public void test() {
        Helper.setShouldOptimizeDates((boolean)true);
        this.optimizedTime = Helper.timestampFromDate((Date)this.currentTime);
    }

    public void verify() {
        String testTime = new Timestamp(this.currentTime.getTime()).toString();
        if (!testTime.equals(this.optimizedTime.toString())) {
            throw new TestErrorException("Failed to convert java.util.Date to java.sql.Timestamp when shouldOptimizedDates is on");
        }
    }

    public void reset() {
        Helper.setShouldOptimizeDates((boolean)this.optimizedDatesState);
    }
}

