/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.util.Vector;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class FirstResultAndMaxRowsTest
extends AutoVerifyTestCase {
    protected int firstResult = 0;
    protected int maxRows = 0;
    protected int expectedResults = 0;
    protected int results = 0;

    public FirstResultAndMaxRowsTest(int firstResult, int maxRows, int expectedResults) {
        this.firstResult = firstResult;
        this.maxRows = maxRows;
        this.expectedResults = expectedResults;
        this.setName("FirstResultAndMaxRowsTest " + firstResult + "," + maxRows);
    }

    public void setup() {
        if (this.getSession().getPlatform().isTimesTen()) {
            throw new TestWarningException("This test is not supported on TimesTen");
        }
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    public void test() {
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        query.setMaxRows(this.maxRows);
        query.setFirstResult(this.firstResult);
        this.results = ((Vector)this.getSession().executeQuery((DatabaseQuery)query)).size();
    }

    public void verify() {
        if (this.results != this.expectedResults) {
            throw new TestErrorException("Expected " + this.expectedResults + " and returned " + this.results + " results. When using maxResults = " + this.maxRows + "and firstResult = " + this.firstResult + ".");
        }
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }
}

