/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.inmemory;

import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class UnitOfWorkConformLikeSpecialCharacterTest
extends TestCase {
    private Vector employees = new Vector();
    private UnitOfWork uow = null;

    public void reset() {
        this.uow.release();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
        this.uow = this.getSession().acquireUnitOfWork();
    }

    public void test() {
        ExpressionBuilder emp = new ExpressionBuilder();
        Expression betty = emp.get("firstName").equal((Object)"Betty");
        Employee employee = (Employee)this.uow.readObject(Employee.class, betty);
        employee.setFirstName("Molly([{}])?*.+^|");
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(Employee.class);
        query.conformResultsInUnitOfWork();
        ExpressionBuilder bldr = new ExpressionBuilder();
        Expression exp = bldr.get("firstName").like("Molly([{}])?*.+^|");
        query.setSelectionCriteria(exp);
        this.employees = (Vector)this.uow.executeQuery((DatabaseQuery)query);
    }

    public void verify() {
        if (this.employees.size() != 1) {
            throw new TestErrorException("Expected 1 employee but retured " + this.employees.size() + " for in-memory 'like' query with special characters.");
        }
    }
}

