/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.descriptors.copying.CloneCopyPolicy;
import org.eclipse.persistence.descriptors.copying.CopyPolicy;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.testing.tests.validation.ExceptionTest;

public class NoSuchMethodWhileInitializingCopyPolicyTest
extends ExceptionTest {
    IntegrityChecker orgIntegrityChecker;

    public NoSuchMethodWhileInitializingCopyPolicyTest() {
        this.setDescription("This tests No Such Method While Initializing Copy Policy (TL-ERROR 62)");
    }

    protected void setup() {
        this.expectedException = DescriptorException.noSuchMethodWhileInitializingCopyPolicy((String)"Dummy_Method", (ClassDescriptor)new RelationalDescriptor(), (Exception)new Exception());
        this.orgIntegrityChecker = this.getSession().getIntegrityChecker();
    }

    @Override
    public void reset() {
        if (this.orgIntegrityChecker != null) {
            this.getSession().setIntegrityChecker(this.orgIntegrityChecker);
        }
    }

    public void test() {
        try {
            this.getSession().setIntegrityChecker(new IntegrityChecker());
            this.getSession().getIntegrityChecker().dontCatchExceptions();
            RelationalDescriptor descriptor = new RelationalDescriptor();
            descriptor.setJavaClass(Object.class);
            descriptor.setCopyPolicy((CopyPolicy)new CloneCopyPolicy());
            CloneCopyPolicy policy = (CloneCopyPolicy)descriptor.getCopyPolicy();
            policy.setMethodName("Dummy_Method");
            policy.initialize(this.getSession());
        }
        catch (EclipseLinkException exception) {
            this.caughtException = exception;
        }
    }
}

