/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DBApiLayer;
import com.mongodb.DBCollection;
import com.mongodb.DBDecoder;
import com.mongodb.DBDecoderFactory;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBCursor
implements Iterator<DBObject>,
Iterable<DBObject> {
    private final DBCollection _collection;
    private final DBObject _query;
    private final DBObject _keysWanted;
    private DBObject _orderBy = null;
    private String _hint = null;
    private DBObject _hintDBObj = null;
    private boolean _explain = false;
    private int _limit = 0;
    private int _batchSize = 0;
    private int _skip = 0;
    private boolean _snapshot = false;
    private int _options = 0;
    private ReadPreference _readPref;
    private DBDecoderFactory _decoderFact;
    private DBObject _specialFields;
    private Iterator<DBObject> _it = null;
    private boolean _fake = false;
    private CursorType _cursorType = null;
    private DBObject _cur = null;
    private int _num = 0;
    private final ArrayList<DBObject> _all = new ArrayList();

    public DBCursor(DBCollection collection, DBObject q, DBObject k, ReadPreference preference) {
        this._collection = collection;
        this._query = q == null ? new BasicDBObject() : q;
        this._keysWanted = k;
        if (this._collection != null) {
            this._options = this._collection.getOptions();
        }
        this._readPref = preference;
        this._decoderFact = collection.getDBDecoderFactory();
    }

    public DBCursor copy() {
        DBCursor c = new DBCursor(this._collection, this._query, this._keysWanted, this._readPref);
        c._orderBy = this._orderBy;
        c._hint = this._hint;
        c._hintDBObj = this._hintDBObj;
        c._limit = this._limit;
        c._skip = this._skip;
        c._options = this._options;
        c._batchSize = this._batchSize;
        c._snapshot = this._snapshot;
        c._explain = this._explain;
        if (this._specialFields != null) {
            c._specialFields = new BasicDBObject(this._specialFields.toMap());
        }
        return c;
    }

    @Override
    public Iterator<DBObject> iterator() {
        return this.copy();
    }

    public DBCursor sort(DBObject orderBy) {
        if (this._it != null) {
            throw new IllegalStateException("can't sort after executing query");
        }
        this._orderBy = orderBy;
        return this;
    }

    public DBCursor addSpecial(String name, Object o) {
        if (this._specialFields == null) {
            this._specialFields = new BasicDBObject();
        }
        this._specialFields.put(name, o);
        return this;
    }

    public DBCursor hint(DBObject indexKeys) {
        if (this._it != null) {
            throw new IllegalStateException("can't hint after executing query");
        }
        this._hintDBObj = indexKeys;
        return this;
    }

    public DBCursor hint(String indexName) {
        if (this._it != null) {
            throw new IllegalStateException("can't hint after executing query");
        }
        this._hint = indexName;
        return this;
    }

    public DBCursor snapshot() {
        if (this._it != null) {
            throw new IllegalStateException("can't snapshot after executing the query");
        }
        this._snapshot = true;
        return this;
    }

    public DBObject explain() {
        DBCursor c = this.copy();
        c._explain = true;
        if (c._limit > 0) {
            c._batchSize = c._limit * -1;
            c._limit = 0;
        }
        return c.next();
    }

    public DBCursor limit(int n) {
        if (this._it != null) {
            throw new IllegalStateException("can't set limit after executing query");
        }
        if (n > 0) {
            this._limit = n;
        } else if (n < 0) {
            this.batchSize(n);
        }
        return this;
    }

    public DBCursor batchSize(int n) {
        if (n == 1) {
            n = 2;
        }
        if (this._it != null && this._it instanceof DBApiLayer.Result) {
            ((DBApiLayer.Result)this._it).setBatchSize(n);
        }
        this._batchSize = n;
        return this;
    }

    public DBCursor skip(int n) {
        if (this._it != null) {
            throw new IllegalStateException("can't set skip after executing query");
        }
        this._skip = n;
        return this;
    }

    public long getCursorId() {
        if (this._it instanceof DBApiLayer.Result) {
            return ((DBApiLayer.Result)this._it).getCursorId();
        }
        return 0L;
    }

    public void close() {
        if (this._it instanceof DBApiLayer.Result) {
            ((DBApiLayer.Result)this._it).close();
        }
    }

    @Deprecated
    public DBCursor slaveOk() {
        return this.addOption(4);
    }

    public DBCursor addOption(int option) {
        if (option == 64) {
            throw new IllegalArgumentException("The exhaust option is not user settable.");
        }
        this._options |= option;
        return this;
    }

    public DBCursor setOptions(int options) {
        this._options = options;
        return this;
    }

    public DBCursor resetOptions() {
        this._options = 0;
        return this;
    }

    public int getOptions() {
        return this._options;
    }

    private void _check() throws MongoException {
        if (this._it != null) {
            return;
        }
        if (this._collection != null && this._query != null) {
            this._lookForHints();
            DBObject foo = this._query;
            if (this.hasSpecialQueryFields()) {
                foo = this._specialFields == null ? new BasicDBObject() : this._specialFields;
                this._addToQueryObject(foo, "query", this._query, true);
                this._addToQueryObject(foo, "orderby", this._orderBy, false);
                if (this._hint != null) {
                    this._addToQueryObject(foo, "$hint", this._hint);
                }
                if (this._hintDBObj != null) {
                    this._addToQueryObject(foo, "$hint", this._hintDBObj);
                }
                if (this._explain) {
                    foo.put("$explain", true);
                }
                if (this._snapshot) {
                    foo.put("$snapshot", true);
                }
            }
            this._it = this._collection.__find(foo, this._keysWanted, this._skip, this._batchSize, this._limit, this._options, this._readPref, this.getDecoder());
        }
        if (this._it == null) {
            this._it = new LinkedList().iterator();
            this._fake = true;
        }
    }

    private DBDecoder getDecoder() {
        return this._decoderFact != null ? this._decoderFact.create() : null;
    }

    private void _lookForHints() {
        if (this._hint != null) {
            return;
        }
        if (this._collection._hintFields == null) {
            return;
        }
        Set<String> mykeys = this._query.keySet();
        for (DBObject o : this._collection._hintFields) {
            Set<String> hintKeys = o.keySet();
            if (!mykeys.containsAll(hintKeys)) continue;
            this.hint(o);
            return;
        }
    }

    boolean hasSpecialQueryFields() {
        if (this._specialFields != null) {
            return true;
        }
        if (this._orderBy != null && this._orderBy.keySet().size() > 0) {
            return true;
        }
        if (this._hint != null || this._hintDBObj != null || this._snapshot) {
            return true;
        }
        return this._explain;
    }

    void _addToQueryObject(DBObject query, String field, DBObject thing, boolean sendEmpty) {
        if (thing == null) {
            return;
        }
        if (!sendEmpty && thing.keySet().size() == 0) {
            return;
        }
        this._addToQueryObject(query, field, thing);
    }

    void _addToQueryObject(DBObject query, String field, Object thing) {
        if (thing == null) {
            return;
        }
        query.put(field, thing);
    }

    void _checkType(CursorType type) {
        if (this._cursorType == null) {
            this._cursorType = type;
            return;
        }
        if (type == this._cursorType) {
            return;
        }
        throw new IllegalArgumentException("can't switch cursor access methods");
    }

    private DBObject _next() throws MongoException {
        if (this._cursorType == null) {
            this._checkType(CursorType.ITERATOR);
        }
        this._check();
        this._cur = this._it.next();
        ++this._num;
        if (this._keysWanted != null && this._keysWanted.keySet().size() > 0) {
            this._cur.markAsPartialObject();
        }
        if (this._cursorType == CursorType.ARRAY) {
            this._all.add(this._cur);
        }
        return this._cur;
    }

    public int numGetMores() {
        if (this._fake) {
            return 0;
        }
        if (this._it instanceof DBApiLayer.Result) {
            return ((DBApiLayer.Result)this._it).numGetMores();
        }
        throw new IllegalArgumentException("_it not a real result");
    }

    public List<Integer> getSizes() {
        if (this._fake) {
            return new LinkedList<Integer>();
        }
        if (this._it instanceof DBApiLayer.Result) {
            return ((DBApiLayer.Result)this._it).getSizes();
        }
        throw new IllegalArgumentException("_it not a real result");
    }

    private boolean _hasNext() throws MongoException {
        this._check();
        if (this._limit > 0 && this._num >= this._limit) {
            return false;
        }
        return this._it.hasNext();
    }

    public int numSeen() {
        return this._num;
    }

    @Override
    public boolean hasNext() throws MongoException {
        this._checkType(CursorType.ITERATOR);
        return this._hasNext();
    }

    @Override
    public DBObject next() throws MongoException {
        this._checkType(CursorType.ITERATOR);
        return this._next();
    }

    public DBObject curr() {
        this._checkType(CursorType.ITERATOR);
        return this._cur;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("can't remove from a cursor");
    }

    void _fill(int n) throws MongoException {
        this._checkType(CursorType.ARRAY);
        while (n >= this._all.size() && this._hasNext()) {
            this._next();
        }
    }

    public int length() throws MongoException {
        this._checkType(CursorType.ARRAY);
        this._fill(Integer.MAX_VALUE);
        return this._all.size();
    }

    public List<DBObject> toArray() throws MongoException {
        return this.toArray(Integer.MAX_VALUE);
    }

    public List<DBObject> toArray(int max) throws MongoException {
        this._checkType(CursorType.ARRAY);
        this._fill(max - 1);
        return this._all;
    }

    public int itcount() {
        int n = 0;
        while (this.hasNext()) {
            this.next();
            ++n;
        }
        return n;
    }

    public int count() throws MongoException {
        if (this._collection == null) {
            throw new IllegalArgumentException("why is _collection null");
        }
        if (this._collection._db == null) {
            throw new IllegalArgumentException("why is _collection._db null");
        }
        return (int)this._collection.getCount(this._query, this._keysWanted);
    }

    public int size() throws MongoException {
        if (this._collection == null) {
            throw new IllegalArgumentException("why is _collection null");
        }
        if (this._collection._db == null) {
            throw new IllegalArgumentException("why is _collection._db null");
        }
        return (int)this._collection.getCount(this._query, this._keysWanted, this._limit, this._skip);
    }

    public DBObject getKeysWanted() {
        return this._keysWanted;
    }

    public DBObject getQuery() {
        return this._query;
    }

    public DBCollection getCollection() {
        return this._collection;
    }

    public ServerAddress getServerAddress() {
        this._check();
        if (this._it != null && this._it instanceof DBApiLayer.Result) {
            return ((DBApiLayer.Result)this._it).getServerAddress();
        }
        return null;
    }

    public DBCursor setReadPreference(ReadPreference preference) {
        this._readPref = preference;
        return this;
    }

    public ReadPreference getReadPreference() {
        return this._readPref;
    }

    public DBCursor setDecoderFactory(DBDecoderFactory fact) {
        this._decoderFact = fact;
        return this;
    }

    public DBDecoderFactory getDecoderFactory() {
        return this._decoderFact;
    }

    public String toString() {
        ServerAddress addr;
        StringBuilder sb = new StringBuilder();
        sb.append("Cursor id=").append(this.getCursorId());
        sb.append(", ns=").append(this.getCollection().getFullName());
        sb.append(", query=").append(this.getQuery());
        if (this.getKeysWanted() != null) {
            sb.append(", fields=").append(this.getKeysWanted());
        }
        sb.append(", numIterated=").append(this._num);
        if (this._skip != 0) {
            sb.append(", skip=").append(this._skip);
        }
        if (this._limit != 0) {
            sb.append(", limit=").append(this._limit);
        }
        if (this._batchSize != 0) {
            sb.append(", batchSize=").append(this._batchSize);
        }
        if ((addr = this.getServerAddress()) != null) {
            sb.append(", addr=").append(addr);
        }
        if (this._readPref != null) {
            sb.append(", readPreference=").append(this._readPref.toString());
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CursorType {
        ITERATOR,
        ARRAY;

    }
}

