/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.helper;

import junit.framework.TestCase;
import org.eclipse.persistence.internal.helper.JavaSEPlatform;
import org.eclipse.persistence.internal.helper.JavaVersion;
import org.junit.Test;

public class JavaUtilTest
extends TestCase {
    public JavaUtilTest(String name) {
        super(name);
    }

    @Test
    public void testJavaVersionCompareTo() {
        JavaVersion version = new JavaVersion(1, 4);
        JavaUtilTest.assertEquals((int)1, (int)version.comapreTo(new JavaVersion(0, 4)));
        JavaUtilTest.assertEquals((int)-1, (int)version.comapreTo(new JavaVersion(2, 4)));
        JavaUtilTest.assertEquals((int)1, (int)version.comapreTo(new JavaVersion(1, 3)));
        JavaUtilTest.assertEquals((int)-1, (int)version.comapreTo(new JavaVersion(1, 5)));
        JavaUtilTest.assertEquals((int)0, (int)version.comapreTo(new JavaVersion(1, 4)));
    }

    @Test
    public void testJavaVersion() {
        JavaVersion version = JavaVersion.vmVersion();
        JavaUtilTest.assertTrue((version.getMajor() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testStringToPlatform() {
        JavaSEPlatform platform;
        String versionString;
        int minor;
        int major;
        int[][] valid = new int[][]{{1, 1}, {1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {1, 7}, {1, 8}, {1, 9}, {9, 0}};
        int[][] invalid = new int[][]{{0, 0}, {0, 1}, {0, 3}, {0, 5}, {0, 7}, {0, 9}, {1, 0}, {2, 0}, {2, 1}, {2, 2}, {3, 0}, {4, 0}, {1, 10}};
        for (int[] version : valid) {
            major = version[0];
            minor = version[1];
            versionString = JavaSEPlatform.versionString((int)major, (int)minor);
            platform = JavaSEPlatform.toValue((String)versionString);
            JavaUtilTest.assertNotNull((String)"There should exist platform for valid platform version numbers.", (Object)platform);
            JavaUtilTest.assertTrue((String)"Returned platform version numbers do not match provided version numbers", (major == platform.getMajor() && minor == platform.getMinor() ? 1 : 0) != 0);
        }
        for (int[] version : invalid) {
            major = version[0];
            minor = version[1];
            versionString = JavaSEPlatform.versionString((int)major, (int)minor);
            platform = JavaSEPlatform.toValue((int)major, (int)minor);
            JavaUtilTest.assertNull((String)"Returned platform shall be null for invalid version number", (Object)platform);
        }
    }

    @Test
    public void testMajorMinorToPlatform() {
        JavaSEPlatform platform;
        int minor;
        int major;
        int[][] valid = new int[][]{{1, 1}, {1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {1, 7}, {1, 8}, {1, 9}, {9, 0}};
        int[][] invalid = new int[][]{{0, 0}, {0, 1}, {0, 3}, {0, 5}, {0, 7}, {0, 9}, {1, 0}, {2, 0}, {2, 1}, {2, 2}, {3, 0}, {4, 0}, {1, 10}};
        for (int[] version : valid) {
            major = version[0];
            minor = version[1];
            platform = JavaSEPlatform.toValue((int)major, (int)minor);
            JavaUtilTest.assertNotNull((String)"There should exist platform for valid platform version numbers.", (Object)platform);
            JavaUtilTest.assertTrue((String)"Returned platform version numbers do not match provided version numbers", (major == platform.getMajor() && minor == platform.getMinor() ? 1 : 0) != 0);
        }
        for (int[] version : invalid) {
            major = version[0];
            minor = version[1];
            platform = JavaSEPlatform.toValue((int)major, (int)minor);
            JavaUtilTest.assertNull((String)"Returned platform shall be null for invalid version number", (Object)platform);
        }
    }

    @Test
    public void testCurrentIs() {
        JavaSEPlatform current = JavaSEPlatform.toValue((int)JavaSEPlatform.CURRENT.getMajor(), (int)JavaSEPlatform.CURRENT.getMinor());
        boolean result = JavaSEPlatform.is((JavaSEPlatform)current);
        JavaUtilTest.assertTrue((String)"Current platform check shall return true.", (boolean)result);
        for (JavaSEPlatform platform : JavaSEPlatform.values()) {
            if (platform.isSupported()) break;
            result = JavaSEPlatform.is((JavaSEPlatform)platform);
            JavaUtilTest.assertFalse((String)"Unsupported platform check shall return false.", (boolean)result);
        }
    }
}

