/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.util.Vector;
import org.eclipse.persistence.descriptors.CMPPolicy;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.PessimisticLockingPolicy;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.remote.RemoteSession;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.LargeProject;
import org.eclipse.persistence.testing.models.employee.domain.Project;
import org.eclipse.persistence.testing.models.employee.domain.SmallProject;
import org.eclipse.persistence.testing.tests.remote.RemoteModel;

public class PessimisticLockInheritanceTest
extends TestCase {
    public UnitOfWork uow;
    public short lockMode;
    CMPPolicy oldCMPPolicy;

    public PessimisticLockInheritanceTest(short lockMode) {
        this.lockMode = lockMode;
        this.setName(this.getName() + "(mode=" + lockMode + ")");
        this.setDescription("This test verifies the pessimistic locking feature works properly when set on the descriptor and inheritance is involved.");
    }

    protected void setup() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        ClassDescriptor projectDescriptor = this.getSession().getDescriptor(Project.class);
        ClassDescriptor largeProjectDescriptor = this.getSession().getDescriptor(LargeProject.class);
        ClassDescriptor smallProjectDescriptor = this.getSession().getDescriptor(SmallProject.class);
        CMPPolicy cmpPolicy = new CMPPolicy();
        PessimisticLockingPolicy policy = new PessimisticLockingPolicy();
        policy.setLockingMode(this.lockMode);
        cmpPolicy.setPessimisticLockingPolicy(policy);
        this.oldCMPPolicy = projectDescriptor.getCMPPolicy();
        projectDescriptor.setCMPPolicy(cmpPolicy);
        projectDescriptor.getQueryManager().getReadObjectQuery().setLockMode((short)-1);
        ((ObjectLevelReadQuery)((ForeignReferenceMapping)projectDescriptor.getMappingForAttributeName("teamLeader")).getSelectionQuery()).setLockMode((short)-1);
        ClassDescriptor employeeDescriptor = this.getSession().getDescriptor(Employee.class);
        ((ObjectLevelReadQuery)((ForeignReferenceMapping)employeeDescriptor.getMappingForAttributeName("projects")).getSelectionQuery()).setLockMode((short)-1);
        largeProjectDescriptor.setCMPPolicy(cmpPolicy);
        largeProjectDescriptor.getQueryManager().getReadObjectQuery().setLockMode((short)-1);
        smallProjectDescriptor.setCMPPolicy(cmpPolicy);
        smallProjectDescriptor.getQueryManager().getReadObjectQuery().setLockMode((short)-1);
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        if (this.uow != null) {
            this.uow.release();
        }
        ClassDescriptor projectDescriptor = this.getSession().getDescriptor(Project.class);
        ClassDescriptor largeProjectDescriptor = this.getSession().getDescriptor(LargeProject.class);
        ClassDescriptor smallProjectDescriptor = this.getSession().getDescriptor(SmallProject.class);
        projectDescriptor.setCMPPolicy(this.oldCMPPolicy);
        ((ObjectLevelReadQuery)((ForeignReferenceMapping)projectDescriptor.getMappingForAttributeName("teamLeader")).getSelectionQuery()).setLockMode((short)-1);
        ((ObjectLevelReadQuery)((ForeignReferenceMapping)projectDescriptor.getMappingForAttributeName("teamLeader")).getSelectionQuery()).dontRefreshIdentityMapResult();
        ClassDescriptor employeeDescriptor = this.getSession().getDescriptor(Employee.class);
        ((ObjectLevelReadQuery)((ForeignReferenceMapping)employeeDescriptor.getMappingForAttributeName("projects")).getSelectionQuery()).setLockMode((short)-1);
        ((ObjectLevelReadQuery)((ForeignReferenceMapping)employeeDescriptor.getMappingForAttributeName("projects")).getSelectionQuery()).dontRefreshIdentityMapResult();
        largeProjectDescriptor.setCMPPolicy(this.oldCMPPolicy);
        smallProjectDescriptor.setCMPPolicy(this.oldCMPPolicy);
    }

    public void test() throws Exception {
        this.checkSelectForUpateSupported();
        if (this.lockMode == 2) {
            this.checkNoWaitSupported();
        }
        this.uow = this.getSession().acquireUnitOfWork();
        ReadObjectQuery query = new ReadObjectQuery(LargeProject.class);
        Expression expression = query.getExpressionBuilder().get("teamLeader").get("firstName").equal((Object)"Charles");
        query.setSelectionCriteria(expression);
        query.addJoinedAttribute("teamLeader");
        Object result = this.uow.executeQuery((DatabaseQuery)query);
        ((LargeProject)result).getTeamLeader();
        ReadObjectQuery cacheQuery = new ReadObjectQuery(Project.class);
        cacheQuery.checkCacheOnly();
        Object cachedObject = this.uow.executeQuery((DatabaseQuery)cacheQuery);
        if (result != cachedObject) {
            throw new TestErrorException("Did not get a cache hit when using pessimistic locking.");
        }
        cacheQuery = new ReadObjectQuery(Employee.class);
        cacheQuery.checkCacheOnly();
        cachedObject = this.uow.executeQuery((DatabaseQuery)cacheQuery);
        if (((LargeProject)result).getTeamLeader() != cachedObject) {
            throw new TestErrorException("Did not get a cache hit after pessimisticly locking a joined attribute.");
        }
        Vector projects = ((Employee)cachedObject).getProjects();
        DatabaseSession session2 = null;
        UnitOfWork uow2 = null;
        try {
            session2 = this.getSession() instanceof RemoteSession ? RemoteModel.getServerSession().getProject().createDatabaseSession() : this.getSession().getProject().createDatabaseSession();
            session2.setLog(this.getSession().getLog());
            session2.setLogLevel(this.getSession().getLogLevel());
            session2.login();
            uow2 = session2.acquireUnitOfWork();
            boolean isLocked = false;
            query = new ReadObjectQuery(Employee.class);
            expression = query.getExpressionBuilder().get("firstName").equal((Object)"Charles");
            query.setSelectionCriteria(expression);
            Employee result2 = (Employee)uow2.executeQuery((DatabaseQuery)query);
            if (result2 == null) {
                throw new TestErrorException("A joined attribute was mistakenly locked pessimistically.");
            }
            projects = null;
            try {
                projects = result2.getProjects();
            }
            catch (EclipseLinkException exeception) {
                session2.logMessage(exeception.toString());
                isLocked = true;
            }
            if (projects == null) {
                isLocked = true;
            }
            if (!isLocked) {
                throw new TestErrorException("Select for update does not acquire a lock");
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            if (uow2 != null) {
                uow2.release();
            }
            if (session2 != null) {
                session2.logout();
            }
        }
    }
}

