/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.transparentindirection.jdk8;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.indirection.IndirectList;
import org.eclipse.persistence.indirection.IndirectMap;
import org.eclipse.persistence.indirection.IndirectSet;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.transparentindirection.BidirectionalRelationshipSystem;
import org.eclipse.persistence.testing.models.transparentindirection.CustomIndirectContainerSystem;
import org.eclipse.persistence.testing.models.transparentindirection.IndirectListSystem;
import org.eclipse.persistence.testing.models.transparentindirection.IndirectMapSystem;
import org.eclipse.persistence.testing.models.transparentindirection.IndirectSetSystem;
import org.eclipse.persistence.testing.tests.transparentindirection.ZTestSuite;
import org.eclipse.persistence.testing.tests.transparentindirection.jdk8.IndirectListTestAPI;
import org.eclipse.persistence.testing.tests.transparentindirection.jdk8.IndirectMapTestAPI;
import org.eclipse.persistence.testing.tests.transparentindirection.jdk8.IndirectSetTestAPI;

public class TransparentIndirectionModel
extends TestModel {
    public TransparentIndirectionModel() {
        this.setDescription("Test Transparent Indirection for Java 8");
    }

    public void addRequiredSystems() {
        this.addRequiredSystem(new IndirectListSystem());
        this.addRequiredSystem(new IndirectMapSystem());
        this.addRequiredSystem(new IndirectSetSystem());
        this.addRequiredSystem(new CustomIndirectContainerSystem());
        this.addRequiredSystem(new BidirectionalRelationshipSystem());
    }

    public void addTests() {
        Class<?> jdk8impl;
        this.addTest((Test)new ZTestSuite(IndirectListTestAPI.class));
        try {
            jdk8impl = Class.forName("org.eclipse.persistence.internal.indirection.jdk8.IndirectList");
            this.addTest((Test)IndirectListTestAPI.getTestSuiteFor(jdk8impl, true));
            this.addTest((Test)IndirectListTestAPI.getTestSuiteFor(jdk8impl, false));
        }
        catch (Throwable t) {
            throw new TestWarningException("JDK 8 impl for IndirectList not found.", t);
        }
        this.addTest((Test)new ZTestSuite(IndirectMapTestAPI.class));
        try {
            jdk8impl = Class.forName("org.eclipse.persistence.internal.indirection.jdk8.IndirectMap");
            this.addTest((Test)IndirectMapTestAPI.getTestSuiteFor(jdk8impl, true));
            this.addTest((Test)IndirectMapTestAPI.getTestSuiteFor(jdk8impl, false));
        }
        catch (Throwable t) {
            throw new TestWarningException("JDK 8 impl for IndirectMap not found.", t);
        }
        this.addTest((Test)new ZTestSuite(IndirectSetTestAPI.class));
        try {
            jdk8impl = Class.forName("org.eclipse.persistence.internal.indirection.jdk8.IndirectSet");
            this.addTest((Test)IndirectSetTestAPI.getTestSuiteFor(jdk8impl, true));
            this.addTest((Test)IndirectSetTestAPI.getTestSuiteFor(jdk8impl, false));
        }
        catch (Throwable t) {
            throw new TestWarningException("JDK 8 impl for IndirectSet not found.", t);
        }
    }

    public static TestSuite suite() {
        return new TransparentIndirectionModel();
    }

    public static final class Z<K, V>
    extends IndirectMap<K, V> {
    }

    public static final class Y<E>
    extends IndirectSet<E> {
    }

    public static final class X<E>
    extends IndirectList<E> {
    }
}

