/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework.junit;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class JUnitTestCaseHelper {
    public static final String DB = "db";
    public static final String DB_DRIVER_KEY = "db.driver";
    public static final String DB_URL_KEY = "db.url";
    public static final String DB_USER_KEY = "db.user";
    public static final String DB_PWD_KEY = "db.pwd";
    public static final String DB_PLATFORM_KEY = "db.platform";
    public static final String DB_SPEC_KEY = "db.spec";
    public static final String LOGGING_LEVEL_KEY = "eclipselink.logging.level";
    public static final String TEST_PROPERTIES_FILE_KEY = "test.properties";
    public static final String TEST_PROPERTIES_FILE_DEFAULT = "test.properties";
    public static Map propertiesMap = null;
    public static Map persistencePropertiesTestMap = new HashMap();
    public static Properties propertiesFromFile = null;
    public static Map<String, Map> puPropertiesMap = new HashMap<String, Map>();
    public static Map<String, Map> dbPropertiesMap = new HashMap<String, Map>();
    public static final String SINGLE_DB = "single.db";
    public static Boolean shouldUseSingleDb;

    public static Map<String, String> getDatabaseProperties() {
        if (propertiesMap == null) {
            propertiesMap = JUnitTestCaseHelper.createDatabaseProperties(null);
            propertiesMap.putAll(persistencePropertiesTestMap);
        }
        return propertiesMap;
    }

    public static Map<String, String> getDatabaseProperties(String puName) {
        Map puProperties = null;
        if (puName != null && puName.length() > 0 && (puProperties = puPropertiesMap.get(puName)) == null) {
            if (puName.equals("composite-advanced") || puName.equals("xml-composite-advanced") || puName.equals("xml-extended-composite-advanced")) {
                String prefix = puName;
                if (puName.equals("xml-extended-composite-advanced")) {
                    prefix = "xml-composite-advanced";
                }
                String[] sessions = new String[]{"member_1", "member_2", "member_3"};
                for (int i = 0; i < sessions.length; ++i) {
                    sessions[i] = prefix + "-" + sessions[i];
                }
                puProperties = JUnitTestCaseHelper.createCompositeProperties(sessions);
            }
            if (puProperties != null) {
                puPropertiesMap.put(puName, puProperties);
            }
        }
        if (puProperties != null) {
            return puProperties;
        }
        return JUnitTestCaseHelper.getDatabaseProperties();
    }

    public static String getProperty(String key) {
        String property = System.getProperty(key);
        return property != null ? property : JUnitTestCaseHelper.getPropertyFromFile(key);
    }

    private static String getPropertyFromFile(String key) {
        if (propertiesFromFile == null) {
            JUnitTestCaseHelper.createPropertiesFromFile();
        }
        return (String)propertiesFromFile.get(key);
    }

    static Map<String, String> createDatabaseProperties(String dbIndex) {
        boolean addLoggingLevel = dbIndex == null || dbIndex.length() == 0;
        String db_driver_key = JUnitTestCaseHelper.insertIndex(DB_DRIVER_KEY, dbIndex);
        String db_url_key = JUnitTestCaseHelper.insertIndex(DB_URL_KEY, dbIndex);
        String db_user_key = JUnitTestCaseHelper.insertIndex(DB_USER_KEY, dbIndex);
        String db_pwd_key = JUnitTestCaseHelper.insertIndex(DB_PWD_KEY, dbIndex);
        String db_platform_key = JUnitTestCaseHelper.insertIndex(DB_PLATFORM_KEY, dbIndex);
        String dbDriver = JUnitTestCaseHelper.getProperty(db_driver_key);
        String dbUrl = JUnitTestCaseHelper.getProperty(db_url_key);
        String dbUser = JUnitTestCaseHelper.getProperty(db_user_key);
        String dbPwd = JUnitTestCaseHelper.getProperty(db_pwd_key);
        String platform = JUnitTestCaseHelper.getProperty(db_platform_key);
        String logLevel = JUnitTestCaseHelper.getProperty(LOGGING_LEVEL_KEY);
        HashMap<String, String> properties = new HashMap<String, String>();
        if (dbDriver != null) {
            properties.put("javax.persistence.jdbc.driver", dbDriver);
        }
        if (dbUrl != null) {
            properties.put("javax.persistence.jdbc.url", dbUrl);
        }
        if (dbUser != null) {
            properties.put("javax.persistence.jdbc.user", dbUser);
        }
        if (dbPwd != null) {
            properties.put("javax.persistence.jdbc.password", dbPwd);
        }
        if (platform != null) {
            properties.put("eclipselink.target-database", platform);
        }
        if (addLoggingLevel && logLevel != null) {
            properties.put(LOGGING_LEVEL_KEY, logLevel);
        }
        return properties;
    }

    public static Map createCompositeProperties(String[] sessions) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        HashMap<String, Map<String, String>> compositeMap = new HashMap<String, Map<String, String>>();
        properties.put("eclipselink.composite-unit.properties", compositeMap);
        Map<String, String> defaultProperties = JUnitTestCaseHelper.getDatabaseProperties();
        String logLevel = defaultProperties.get(LOGGING_LEVEL_KEY);
        if (logLevel != null) {
            properties.put(LOGGING_LEVEL_KEY, logLevel);
        }
        compositeMap.put(sessions[0], defaultProperties);
        for (int i = 1; i < sessions.length; ++i) {
            String dbIndex = Integer.toString(i + 1);
            Map<String, String> sessionProperties = JUnitTestCaseHelper.getDatabasePropertiesForIndex(dbIndex);
            if (sessionProperties.isEmpty() && JUnitTestCaseHelper.shouldUseSingleDb()) {
                sessionProperties = defaultProperties;
            }
            if (sessionProperties.isEmpty()) continue;
            compositeMap.put(sessions[i], sessionProperties);
        }
        return properties;
    }

    public static String insertIndex(String key, String index) {
        if (index == null || index.length() == 0) {
            return key;
        }
        String suffix = key.substring(DB.length(), key.length());
        return DB + index + suffix;
    }

    public static Map<String, String> getDatabasePropertiesForIndex(String dbIndex) {
        if (dbIndex != null && dbIndex.length() > 0) {
            Map<String, String> dbProperties = dbPropertiesMap.get(dbIndex);
            if (dbProperties == null) {
                dbProperties = JUnitTestCaseHelper.createDatabaseProperties(dbIndex);
                dbPropertiesMap.put(dbIndex, dbProperties);
            }
            return dbProperties;
        }
        throw new RuntimeException("dbIndex is null or an empty String");
    }

    public static void createPropertiesFromFile() {
        propertiesFromFile = new Properties();
        File testPropertiesFile = new File(System.getProperty("test.properties", "test.properties"));
        URL url = null;
        if (testPropertiesFile.exists()) {
            try {
                url = testPropertiesFile.toURL();
            }
            catch (MalformedURLException exception) {
                throw new RuntimeException("Error loading " + testPropertiesFile.getName() + ".", exception);
            }
        } else {
            url = JUnitTestCaseHelper.class.getResource("/" + System.getProperty("test.properties", "test.properties"));
        }
        if (url != null) {
            try {
                propertiesFromFile.load(url.openStream());
            }
            catch (IOException exception) {
                throw new RuntimeException("Error loading " + testPropertiesFile.getName() + ".", exception);
            }
        }
    }

    public static boolean shouldUseSingleDb() {
        if (shouldUseSingleDb == null) {
            shouldUseSingleDb = Boolean.TRUE;
            String property = System.getProperty(SINGLE_DB);
            if (property == null) {
                property = JUnitTestCaseHelper.getPropertyFromFile(SINGLE_DB);
            }
            if (property != null && property.toUpperCase().equals("FALSE")) {
                shouldUseSingleDb = Boolean.FALSE;
            }
        }
        return shouldUseSingleDb;
    }

    static {
        persistencePropertiesTestMap.put("eclipselink.jdbc.read-connections.shared", "false");
        persistencePropertiesTestMap.put("eclipselink.jdbc.write-connections.initial", "0");
        persistencePropertiesTestMap.put("eclipselink.jdbc.write-connections.min", "4");
        persistencePropertiesTestMap.put("eclipselink.jdbc.write-connections.max", "9");
        persistencePropertiesTestMap.put("eclipselink.jdbc.read-connections.min", "4");
        persistencePropertiesTestMap.put("eclipselink.jdbc.read-connections.max", "4");
        persistencePropertiesTestMap.put("eclipselink.jdbc.batch-writing.size", "150");
    }
}

